<?php
/**
 * Helper functions for the APIs.
 *
 * @author Congyu Fan
 * @since Mar 17, 2017
 */

use \Azi\Input;

/**
 * Get the password submitted by the user.
 *
 * @return string|null
 */
if (!function_exists('ntAPIGetUserTeamPwd')) {
    function ntAPIGetUserTeamPwd()
    {
        if (!Input::exists('team_pwd')) {
            return null;
        }

        return Input::request('team_pwd');
    }
}

if (!function_exists('ntAPIInvokeController')) {
    /**
     * Invoke a controller method, generate a json string response, and handle exceptions
     * In a controller method, please use parameter name "con" to receive a DB connection
     *
     * @param string $controllerName   The class name of a controller
     * @param string $methodName       The method name
     * @param array $methodArgs        Arguments
     * @return string   A JSON string
     */
    function ntAPIInvokeControllerMethod($controllerName, $methodName, $methodArgs = []) {
        // Get a DB connection
        $con = \Propel\Runtime\Propel::getConnection();
        // Store it into the arg list
        $methodArgs['con'] = $con;

        $con->beginTransaction();
        try {
            // call method
            $ret = ntInvokeControllerMethod($controllerName, $methodName, $methodArgs);
            // Commit transaction
            $con->commit();
            return $ret;
        } catch (\Propel\Runtime\Exception\PropelException $e) {
            //Handle database error
            $con->rollBack();
            return \App\Misc\API\APIResponseGenerator::genJsonErrorMsg(\Kayex\HttpCodes::HTTP_INTERNAL_SERVER_ERROR, ntGetStringLiteral('DATABASE_ERROR'));
        } catch (\App\Misc\Exception\RequestErrorException $e) {
            // Handle customized request problem
            $con->rollBack();
            return \App\Misc\API\APIResponseGenerator::genJsonErrorMsg($e->getCode(), $e->getMessage());
        } catch (Exception $e) {
            // Handle the other exceptions
            $con->rollBack();
            return \App\Misc\API\APIResponseGenerator::genJsonErrorMsg(\Kayex\HttpCodes::HTTP_INTERNAL_SERVER_ERROR, /*'An unexpected exception was caught'*/ $e->getMessage());
        }
    }
}