
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

-- ---------------------------------------------------------------------
-- nt_staff
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_staff`;

CREATE TABLE `nt_staff`
(
    `staff_id` INTEGER NOT NULL AUTO_INCREMENT,
    `email` VARCHAR(254) NOT NULL,
    `password` CHAR(32) NOT NULL,
    `token` CHAR(8),
    `salt` CHAR(4) NOT NULL,
    PRIMARY KEY (`staff_id`),
    UNIQUE INDEX `UQ_Staff_UserName` (`email`)
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_location
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_location`;

CREATE TABLE `nt_location`
(
    `hunt_id` INTEGER NOT NULL,
    `location_order` INTEGER NOT NULL,
    `name` VARCHAR(20) NOT NULL,
    `clue` VARCHAR(120) NOT NULL,
    `latitude` DECIMAL(9,6) NOT NULL,
    `longitude` DECIMAL(9,6) NOT NULL,
    PRIMARY KEY (`hunt_id`,`location_order`),
    CONSTRAINT `FK_HuntUseLocation_Hunt_HuntID`
        FOREIGN KEY (`hunt_id`)
        REFERENCES `nt_hunt` (`hunt_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_location_template
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_location_template`;

CREATE TABLE `nt_location_template`
(
    `location_id` INTEGER NOT NULL AUTO_INCREMENT,
    `creator_id` INTEGER NOT NULL,
    `name` VARCHAR(20) NOT NULL,
    `clue` VARCHAR(120) NOT NULL,
    `latitude` DECIMAL(9,6) NOT NULL,
    `longitude` DECIMAL(9,6) NOT NULL,
    PRIMARY KEY (`location_id`),
    INDEX `fi_Location_StaffTemplate_CreatorID` (`creator_id`),
    CONSTRAINT `FK_Location_StaffTemplate_CreatorID`
        FOREIGN KEY (`creator_id`)
        REFERENCES `nt_staff` (`staff_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_hunt
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_hunt`;

CREATE TABLE `nt_hunt`
(
    `hunt_id` INTEGER NOT NULL AUTO_INCREMENT,
    `creator_id` INTEGER NOT NULL,
    `hunt_name` VARCHAR(20) NOT NULL,
    `start_time` INTEGER DEFAULT 0 NOT NULL,
    `duration` INTEGER NOT NULL,
    `difficulty` INTEGER DEFAULT 0 NOT NULL,
    PRIMARY KEY (`hunt_id`),
    INDEX `fi_Hunt_Staff_CreatorID` (`creator_id`),
    CONSTRAINT `FK_Hunt_Staff_CreatorID`
        FOREIGN KEY (`creator_id`)
        REFERENCES `nt_staff` (`staff_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_team
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_team`;

CREATE TABLE `nt_team`
(
    `team_id` INTEGER NOT NULL AUTO_INCREMENT,
    `hunt_id` INTEGER NOT NULL,
    `team_pwd` VARCHAR(20) NOT NULL,
    `team_name` VARCHAR(15),
    `email` VARCHAR(254),
    `last_email` INTEGER DEFAULT 0 NOT NULL,
    `loc_offset` INTEGER DEFAULT 0 NOT NULL,
    `total_dist` INTEGER DEFAULT 0 NOT NULL,
    PRIMARY KEY (`team_id`),
    UNIQUE INDEX `UQ_Team_HuntID_TeamName` (`hunt_id`, `team_name`),
    UNIQUE INDEX `UQ_Team_TeamPWD` (`team_pwd`),
    CONSTRAINT `FK_Team_Hunt_HuntID`
        FOREIGN KEY (`hunt_id`)
        REFERENCES `nt_hunt` (`hunt_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_game_record
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_game_record`;

CREATE TABLE `nt_game_record`
(
    `team_id` INTEGER NOT NULL,
    `time_first_get_loc` INTEGER DEFAULT 0 NOT NULL,
    `clues_found` INTEGER DEFAULT 0 NOT NULL,
    `reveal_time` INTEGER DEFAULT 0 NOT NULL,
    `rank` INTEGER DEFAULT 0 NOT NULL,
    `question` INTEGER DEFAULT 0 NOT NULL,
    PRIMARY KEY (`team_id`),
    CONSTRAINT `FK_GameRecord_Team_TeamID`
        FOREIGN KEY (`team_id`)
        REFERENCES `nt_team` (`team_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_quiz_question
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_quiz_question`;

CREATE TABLE `nt_quiz_question`
(
    `question_id` INTEGER NOT NULL AUTO_INCREMENT,
    `hunt_id` INTEGER NOT NULL,
    `question` VARCHAR(100) NOT NULL,
    `right_ans` INTEGER DEFAULT -1 NOT NULL,
    PRIMARY KEY (`question_id`),
    INDEX `fi_QuizQuestion_Hunt_HuntID` (`hunt_id`),
    CONSTRAINT `FK_QuizQuestion_Hunt_HuntID`
        FOREIGN KEY (`hunt_id`)
        REFERENCES `nt_hunt` (`hunt_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

-- ---------------------------------------------------------------------
-- nt_quiz_option
-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS `nt_quiz_option`;

CREATE TABLE `nt_quiz_option`
(
    `question_id` INTEGER NOT NULL,
    `quiz_order` INTEGER NOT NULL,
    `quiz_option` VARCHAR(30) NOT NULL,
    PRIMARY KEY (`question_id`,`quiz_order`),
    CONSTRAINT `FK_QuizOption_QuizQuestion_QuestionID`
        FOREIGN KEY (`question_id`)
        REFERENCES `nt_quiz_question` (`question_id`)
        ON UPDATE CASCADE
        ON DELETE CASCADE
) ENGINE=InnoDB;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
