<?php

namespace Nutty\Models\Map;

use Nutty\Models\QuizQuestion;
use Nutty\Models\QuizQuestionQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'nt_quiz_question' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class QuizQuestionTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Nutty.Models.Map.QuizQuestionTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'nutty';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'nt_quiz_question';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Nutty\\Models\\QuizQuestion';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Nutty.Models.QuizQuestion';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 4;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 4;

    /**
     * the column name for the question_id field
     */
    const COL_QUESTION_ID = 'nt_quiz_question.question_id';

    /**
     * the column name for the hunt_id field
     */
    const COL_HUNT_ID = 'nt_quiz_question.hunt_id';

    /**
     * the column name for the question field
     */
    const COL_QUESTION = 'nt_quiz_question.question';

    /**
     * the column name for the right_ans field
     */
    const COL_RIGHT_ANS = 'nt_quiz_question.right_ans';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('QuestionID', 'HuntID', 'Question', 'RightANS', ),
        self::TYPE_CAMELNAME     => array('questionID', 'huntID', 'question', 'rightANS', ),
        self::TYPE_COLNAME       => array(QuizQuestionTableMap::COL_QUESTION_ID, QuizQuestionTableMap::COL_HUNT_ID, QuizQuestionTableMap::COL_QUESTION, QuizQuestionTableMap::COL_RIGHT_ANS, ),
        self::TYPE_FIELDNAME     => array('question_id', 'hunt_id', 'question', 'right_ans', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('QuestionID' => 0, 'HuntID' => 1, 'Question' => 2, 'RightANS' => 3, ),
        self::TYPE_CAMELNAME     => array('questionID' => 0, 'huntID' => 1, 'question' => 2, 'rightANS' => 3, ),
        self::TYPE_COLNAME       => array(QuizQuestionTableMap::COL_QUESTION_ID => 0, QuizQuestionTableMap::COL_HUNT_ID => 1, QuizQuestionTableMap::COL_QUESTION => 2, QuizQuestionTableMap::COL_RIGHT_ANS => 3, ),
        self::TYPE_FIELDNAME     => array('question_id' => 0, 'hunt_id' => 1, 'question' => 2, 'right_ans' => 3, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('nt_quiz_question');
        $this->setPhpName('QuizQuestion');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\Nutty\\Models\\QuizQuestion');
        $this->setPackage('Nutty.Models');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('question_id', 'QuestionID', 'INTEGER', true, null, null);
        $this->addForeignKey('hunt_id', 'HuntID', 'INTEGER', 'nt_hunt', 'hunt_id', true, null, null);
        $this->addColumn('question', 'Question', 'VARCHAR', true, 100, null);
        $this->addColumn('right_ans', 'RightANS', 'INTEGER', true, null, -1);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Hunt', '\\Nutty\\Models\\Hunt', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':hunt_id',
    1 => ':hunt_id',
  ),
), 'CASCADE', 'CASCADE', null, false);
        $this->addRelation('QuizOption', '\\Nutty\\Models\\QuizOption', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':question_id',
    1 => ':question_id',
  ),
), 'CASCADE', 'CASCADE', 'QuizOptions', false);
    } // buildRelations()
    /**
     * Method to invalidate the instance pool of all tables related to nt_quiz_question     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        QuizOptionTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('QuestionID', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? QuizQuestionTableMap::CLASS_DEFAULT : QuizQuestionTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (QuizQuestion object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = QuizQuestionTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = QuizQuestionTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + QuizQuestionTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = QuizQuestionTableMap::OM_CLASS;
            /** @var QuizQuestion $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            QuizQuestionTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = QuizQuestionTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = QuizQuestionTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var QuizQuestion $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                QuizQuestionTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(QuizQuestionTableMap::COL_QUESTION_ID);
            $criteria->addSelectColumn(QuizQuestionTableMap::COL_HUNT_ID);
            $criteria->addSelectColumn(QuizQuestionTableMap::COL_QUESTION);
            $criteria->addSelectColumn(QuizQuestionTableMap::COL_RIGHT_ANS);
        } else {
            $criteria->addSelectColumn($alias . '.question_id');
            $criteria->addSelectColumn($alias . '.hunt_id');
            $criteria->addSelectColumn($alias . '.question');
            $criteria->addSelectColumn($alias . '.right_ans');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(QuizQuestionTableMap::DATABASE_NAME)->getTable(QuizQuestionTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(QuizQuestionTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(QuizQuestionTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new QuizQuestionTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a QuizQuestion or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or QuizQuestion object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizQuestionTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Nutty\Models\QuizQuestion) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(QuizQuestionTableMap::DATABASE_NAME);
            $criteria->add(QuizQuestionTableMap::COL_QUESTION_ID, (array) $values, Criteria::IN);
        }

        $query = QuizQuestionQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            QuizQuestionTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                QuizQuestionTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the nt_quiz_question table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return QuizQuestionQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a QuizQuestion or Criteria object.
     *
     * @param mixed               $criteria Criteria or QuizQuestion object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizQuestionTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from QuizQuestion object
        }

        if ($criteria->containsKey(QuizQuestionTableMap::COL_QUESTION_ID) && $criteria->keyContainsValue(QuizQuestionTableMap::COL_QUESTION_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.QuizQuestionTableMap::COL_QUESTION_ID.')');
        }


        // Set the correct dbName
        $query = QuizQuestionQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // QuizQuestionTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
QuizQuestionTableMap::buildTableMap();
