<?php

namespace Nutty\Models\Map;

use Nutty\Models\LocationTemplate;
use Nutty\Models\LocationTemplateQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'nt_location_template' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class LocationTemplateTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Nutty.Models.Map.LocationTemplateTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'nutty';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'nt_location_template';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Nutty\\Models\\LocationTemplate';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Nutty.Models.LocationTemplate';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the location_id field
     */
    const COL_LOCATION_ID = 'nt_location_template.location_id';

    /**
     * the column name for the creator_id field
     */
    const COL_CREATOR_ID = 'nt_location_template.creator_id';

    /**
     * the column name for the name field
     */
    const COL_NAME = 'nt_location_template.name';

    /**
     * the column name for the clue field
     */
    const COL_CLUE = 'nt_location_template.clue';

    /**
     * the column name for the latitude field
     */
    const COL_LATITUDE = 'nt_location_template.latitude';

    /**
     * the column name for the longitude field
     */
    const COL_LONGITUDE = 'nt_location_template.longitude';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('LocationID', 'CreatorID', 'Name', 'Clue', 'Latitude', 'Longitude', ),
        self::TYPE_CAMELNAME     => array('locationID', 'creatorID', 'name', 'clue', 'latitude', 'longitude', ),
        self::TYPE_COLNAME       => array(LocationTemplateTableMap::COL_LOCATION_ID, LocationTemplateTableMap::COL_CREATOR_ID, LocationTemplateTableMap::COL_NAME, LocationTemplateTableMap::COL_CLUE, LocationTemplateTableMap::COL_LATITUDE, LocationTemplateTableMap::COL_LONGITUDE, ),
        self::TYPE_FIELDNAME     => array('location_id', 'creator_id', 'name', 'clue', 'latitude', 'longitude', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('LocationID' => 0, 'CreatorID' => 1, 'Name' => 2, 'Clue' => 3, 'Latitude' => 4, 'Longitude' => 5, ),
        self::TYPE_CAMELNAME     => array('locationID' => 0, 'creatorID' => 1, 'name' => 2, 'clue' => 3, 'latitude' => 4, 'longitude' => 5, ),
        self::TYPE_COLNAME       => array(LocationTemplateTableMap::COL_LOCATION_ID => 0, LocationTemplateTableMap::COL_CREATOR_ID => 1, LocationTemplateTableMap::COL_NAME => 2, LocationTemplateTableMap::COL_CLUE => 3, LocationTemplateTableMap::COL_LATITUDE => 4, LocationTemplateTableMap::COL_LONGITUDE => 5, ),
        self::TYPE_FIELDNAME     => array('location_id' => 0, 'creator_id' => 1, 'name' => 2, 'clue' => 3, 'latitude' => 4, 'longitude' => 5, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('nt_location_template');
        $this->setPhpName('LocationTemplate');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\Nutty\\Models\\LocationTemplate');
        $this->setPackage('Nutty.Models');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('location_id', 'LocationID', 'INTEGER', true, null, null);
        $this->addForeignKey('creator_id', 'CreatorID', 'INTEGER', 'nt_staff', 'staff_id', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', true, 20, null);
        $this->addColumn('clue', 'Clue', 'VARCHAR', true, 120, null);
        $this->addColumn('latitude', 'Latitude', 'DECIMAL', true, 9, null);
        $this->addColumn('longitude', 'Longitude', 'DECIMAL', true, 9, null);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Staff', '\\Nutty\\Models\\Staff', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':creator_id',
    1 => ':staff_id',
  ),
), 'CASCADE', 'CASCADE', null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('LocationID', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? LocationTemplateTableMap::CLASS_DEFAULT : LocationTemplateTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (LocationTemplate object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = LocationTemplateTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = LocationTemplateTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + LocationTemplateTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = LocationTemplateTableMap::OM_CLASS;
            /** @var LocationTemplate $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            LocationTemplateTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = LocationTemplateTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = LocationTemplateTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var LocationTemplate $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                LocationTemplateTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_LOCATION_ID);
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_CREATOR_ID);
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_NAME);
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_CLUE);
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_LATITUDE);
            $criteria->addSelectColumn(LocationTemplateTableMap::COL_LONGITUDE);
        } else {
            $criteria->addSelectColumn($alias . '.location_id');
            $criteria->addSelectColumn($alias . '.creator_id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.clue');
            $criteria->addSelectColumn($alias . '.latitude');
            $criteria->addSelectColumn($alias . '.longitude');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(LocationTemplateTableMap::DATABASE_NAME)->getTable(LocationTemplateTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(LocationTemplateTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(LocationTemplateTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new LocationTemplateTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a LocationTemplate or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or LocationTemplate object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(LocationTemplateTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Nutty\Models\LocationTemplate) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(LocationTemplateTableMap::DATABASE_NAME);
            $criteria->add(LocationTemplateTableMap::COL_LOCATION_ID, (array) $values, Criteria::IN);
        }

        $query = LocationTemplateQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            LocationTemplateTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                LocationTemplateTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the nt_location_template table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return LocationTemplateQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a LocationTemplate or Criteria object.
     *
     * @param mixed               $criteria Criteria or LocationTemplate object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(LocationTemplateTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from LocationTemplate object
        }

        if ($criteria->containsKey(LocationTemplateTableMap::COL_LOCATION_ID) && $criteria->keyContainsValue(LocationTemplateTableMap::COL_LOCATION_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.LocationTemplateTableMap::COL_LOCATION_ID.')');
        }


        // Set the correct dbName
        $query = LocationTemplateQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // LocationTemplateTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
LocationTemplateTableMap::buildTableMap();
