<?php

namespace Nutty\Models\Map;

use Nutty\Models\GameRecord;
use Nutty\Models\GameRecordQuery;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;


/**
 * This class defines the structure of the 'nt_game_record' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 *
 */
class GameRecordTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Nutty.Models.Map.GameRecordTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'nutty';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'nt_game_record';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Nutty\\Models\\GameRecord';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Nutty.Models.GameRecord';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 6;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 6;

    /**
     * the column name for the team_id field
     */
    const COL_TEAM_ID = 'nt_game_record.team_id';

    /**
     * the column name for the time_first_get_loc field
     */
    const COL_TIME_FIRST_GET_LOC = 'nt_game_record.time_first_get_loc';

    /**
     * the column name for the clues_found field
     */
    const COL_CLUES_FOUND = 'nt_game_record.clues_found';

    /**
     * the column name for the reveal_time field
     */
    const COL_REVEAL_TIME = 'nt_game_record.reveal_time';

    /**
     * the column name for the rank field
     */
    const COL_RANK = 'nt_game_record.rank';

    /**
     * the column name for the question field
     */
    const COL_QUESTION = 'nt_game_record.question';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('TeamID', 'TimeFirstGetLoc', 'CluesFound', 'RevealTime', 'Rank', 'Question', ),
        self::TYPE_CAMELNAME     => array('teamID', 'timeFirstGetLoc', 'cluesFound', 'revealTime', 'rank', 'question', ),
        self::TYPE_COLNAME       => array(GameRecordTableMap::COL_TEAM_ID, GameRecordTableMap::COL_TIME_FIRST_GET_LOC, GameRecordTableMap::COL_CLUES_FOUND, GameRecordTableMap::COL_REVEAL_TIME, GameRecordTableMap::COL_RANK, GameRecordTableMap::COL_QUESTION, ),
        self::TYPE_FIELDNAME     => array('team_id', 'time_first_get_loc', 'clues_found', 'reveal_time', 'rank', 'question', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('TeamID' => 0, 'TimeFirstGetLoc' => 1, 'CluesFound' => 2, 'RevealTime' => 3, 'Rank' => 4, 'Question' => 5, ),
        self::TYPE_CAMELNAME     => array('teamID' => 0, 'timeFirstGetLoc' => 1, 'cluesFound' => 2, 'revealTime' => 3, 'rank' => 4, 'question' => 5, ),
        self::TYPE_COLNAME       => array(GameRecordTableMap::COL_TEAM_ID => 0, GameRecordTableMap::COL_TIME_FIRST_GET_LOC => 1, GameRecordTableMap::COL_CLUES_FOUND => 2, GameRecordTableMap::COL_REVEAL_TIME => 3, GameRecordTableMap::COL_RANK => 4, GameRecordTableMap::COL_QUESTION => 5, ),
        self::TYPE_FIELDNAME     => array('team_id' => 0, 'time_first_get_loc' => 1, 'clues_found' => 2, 'reveal_time' => 3, 'rank' => 4, 'question' => 5, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('nt_game_record');
        $this->setPhpName('GameRecord');
        $this->setIdentifierQuoting(false);
        $this->setClassName('\\Nutty\\Models\\GameRecord');
        $this->setPackage('Nutty.Models');
        $this->setUseIdGenerator(false);
        // columns
        $this->addForeignPrimaryKey('team_id', 'TeamID', 'INTEGER' , 'nt_team', 'team_id', true, null, null);
        $this->addColumn('time_first_get_loc', 'TimeFirstGetLoc', 'INTEGER', true, null, 0);
        $this->addColumn('clues_found', 'CluesFound', 'INTEGER', true, null, 0);
        $this->addColumn('reveal_time', 'RevealTime', 'INTEGER', true, null, 0);
        $this->addColumn('rank', 'Rank', 'INTEGER', true, null, 0);
        $this->addColumn('question', 'Question', 'INTEGER', true, null, 0);
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('Team', '\\Nutty\\Models\\Team', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':team_id',
    1 => ':team_id',
  ),
), 'CASCADE', 'CASCADE', null, false);
    } // buildRelations()

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? GameRecordTableMap::CLASS_DEFAULT : GameRecordTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (GameRecord object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = GameRecordTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = GameRecordTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + GameRecordTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = GameRecordTableMap::OM_CLASS;
            /** @var GameRecord $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            GameRecordTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = GameRecordTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = GameRecordTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var GameRecord $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                GameRecordTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(GameRecordTableMap::COL_TEAM_ID);
            $criteria->addSelectColumn(GameRecordTableMap::COL_TIME_FIRST_GET_LOC);
            $criteria->addSelectColumn(GameRecordTableMap::COL_CLUES_FOUND);
            $criteria->addSelectColumn(GameRecordTableMap::COL_REVEAL_TIME);
            $criteria->addSelectColumn(GameRecordTableMap::COL_RANK);
            $criteria->addSelectColumn(GameRecordTableMap::COL_QUESTION);
        } else {
            $criteria->addSelectColumn($alias . '.team_id');
            $criteria->addSelectColumn($alias . '.time_first_get_loc');
            $criteria->addSelectColumn($alias . '.clues_found');
            $criteria->addSelectColumn($alias . '.reveal_time');
            $criteria->addSelectColumn($alias . '.rank');
            $criteria->addSelectColumn($alias . '.question');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(GameRecordTableMap::DATABASE_NAME)->getTable(GameRecordTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(GameRecordTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(GameRecordTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new GameRecordTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a GameRecord or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or GameRecord object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GameRecordTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Nutty\Models\GameRecord) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(GameRecordTableMap::DATABASE_NAME);
            $criteria->add(GameRecordTableMap::COL_TEAM_ID, (array) $values, Criteria::IN);
        }

        $query = GameRecordQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            GameRecordTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                GameRecordTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the nt_game_record table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return GameRecordQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a GameRecord or Criteria object.
     *
     * @param mixed               $criteria Criteria or GameRecord object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GameRecordTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from GameRecord object
        }


        // Set the correct dbName
        $query = GameRecordQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // GameRecordTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
GameRecordTableMap::buildTableMap();
