<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\Team as ChildTeam;
use Nutty\Models\TeamQuery as ChildTeamQuery;
use Nutty\Models\Map\TeamTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_team' table.
 *
 *
 *
 * @method     ChildTeamQuery orderByTeamID($order = Criteria::ASC) Order by the team_id column
 * @method     ChildTeamQuery orderByHuntID($order = Criteria::ASC) Order by the hunt_id column
 * @method     ChildTeamQuery orderByTeamPWD($order = Criteria::ASC) Order by the team_pwd column
 * @method     ChildTeamQuery orderByTeamName($order = Criteria::ASC) Order by the team_name column
 * @method     ChildTeamQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildTeamQuery orderByLastEmail($order = Criteria::ASC) Order by the last_email column
 * @method     ChildTeamQuery orderByLocOffset($order = Criteria::ASC) Order by the loc_offset column
 * @method     ChildTeamQuery orderByTotalDist($order = Criteria::ASC) Order by the total_dist column
 *
 * @method     ChildTeamQuery groupByTeamID() Group by the team_id column
 * @method     ChildTeamQuery groupByHuntID() Group by the hunt_id column
 * @method     ChildTeamQuery groupByTeamPWD() Group by the team_pwd column
 * @method     ChildTeamQuery groupByTeamName() Group by the team_name column
 * @method     ChildTeamQuery groupByEmail() Group by the email column
 * @method     ChildTeamQuery groupByLastEmail() Group by the last_email column
 * @method     ChildTeamQuery groupByLocOffset() Group by the loc_offset column
 * @method     ChildTeamQuery groupByTotalDist() Group by the total_dist column
 *
 * @method     ChildTeamQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildTeamQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildTeamQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildTeamQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildTeamQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildTeamQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildTeamQuery leftJoinHunt($relationAlias = null) Adds a LEFT JOIN clause to the query using the Hunt relation
 * @method     ChildTeamQuery rightJoinHunt($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Hunt relation
 * @method     ChildTeamQuery innerJoinHunt($relationAlias = null) Adds a INNER JOIN clause to the query using the Hunt relation
 *
 * @method     ChildTeamQuery joinWithHunt($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Hunt relation
 *
 * @method     ChildTeamQuery leftJoinWithHunt() Adds a LEFT JOIN clause and with to the query using the Hunt relation
 * @method     ChildTeamQuery rightJoinWithHunt() Adds a RIGHT JOIN clause and with to the query using the Hunt relation
 * @method     ChildTeamQuery innerJoinWithHunt() Adds a INNER JOIN clause and with to the query using the Hunt relation
 *
 * @method     ChildTeamQuery leftJoinGameRecord($relationAlias = null) Adds a LEFT JOIN clause to the query using the GameRecord relation
 * @method     ChildTeamQuery rightJoinGameRecord($relationAlias = null) Adds a RIGHT JOIN clause to the query using the GameRecord relation
 * @method     ChildTeamQuery innerJoinGameRecord($relationAlias = null) Adds a INNER JOIN clause to the query using the GameRecord relation
 *
 * @method     ChildTeamQuery joinWithGameRecord($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the GameRecord relation
 *
 * @method     ChildTeamQuery leftJoinWithGameRecord() Adds a LEFT JOIN clause and with to the query using the GameRecord relation
 * @method     ChildTeamQuery rightJoinWithGameRecord() Adds a RIGHT JOIN clause and with to the query using the GameRecord relation
 * @method     ChildTeamQuery innerJoinWithGameRecord() Adds a INNER JOIN clause and with to the query using the GameRecord relation
 *
 * @method     \Nutty\Models\HuntQuery|\Nutty\Models\GameRecordQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildTeam findOne(ConnectionInterface $con = null) Return the first ChildTeam matching the query
 * @method     ChildTeam findOneOrCreate(ConnectionInterface $con = null) Return the first ChildTeam matching the query, or a new ChildTeam object populated from the query conditions when no match is found
 *
 * @method     ChildTeam findOneByTeamID(int $team_id) Return the first ChildTeam filtered by the team_id column
 * @method     ChildTeam findOneByHuntID(int $hunt_id) Return the first ChildTeam filtered by the hunt_id column
 * @method     ChildTeam findOneByTeamPWD(string $team_pwd) Return the first ChildTeam filtered by the team_pwd column
 * @method     ChildTeam findOneByTeamName(string $team_name) Return the first ChildTeam filtered by the team_name column
 * @method     ChildTeam findOneByEmail(string $email) Return the first ChildTeam filtered by the email column
 * @method     ChildTeam findOneByLastEmail(int $last_email) Return the first ChildTeam filtered by the last_email column
 * @method     ChildTeam findOneByLocOffset(int $loc_offset) Return the first ChildTeam filtered by the loc_offset column
 * @method     ChildTeam findOneByTotalDist(int $total_dist) Return the first ChildTeam filtered by the total_dist column *

 * @method     ChildTeam requirePk($key, ConnectionInterface $con = null) Return the ChildTeam by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOne(ConnectionInterface $con = null) Return the first ChildTeam matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildTeam requireOneByTeamID(int $team_id) Return the first ChildTeam filtered by the team_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByHuntID(int $hunt_id) Return the first ChildTeam filtered by the hunt_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByTeamPWD(string $team_pwd) Return the first ChildTeam filtered by the team_pwd column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByTeamName(string $team_name) Return the first ChildTeam filtered by the team_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByEmail(string $email) Return the first ChildTeam filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByLastEmail(int $last_email) Return the first ChildTeam filtered by the last_email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByLocOffset(int $loc_offset) Return the first ChildTeam filtered by the loc_offset column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildTeam requireOneByTotalDist(int $total_dist) Return the first ChildTeam filtered by the total_dist column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildTeam[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildTeam objects based on current ModelCriteria
 * @method     ChildTeam[]|ObjectCollection findByTeamID(int $team_id) Return ChildTeam objects filtered by the team_id column
 * @method     ChildTeam[]|ObjectCollection findByHuntID(int $hunt_id) Return ChildTeam objects filtered by the hunt_id column
 * @method     ChildTeam[]|ObjectCollection findByTeamPWD(string $team_pwd) Return ChildTeam objects filtered by the team_pwd column
 * @method     ChildTeam[]|ObjectCollection findByTeamName(string $team_name) Return ChildTeam objects filtered by the team_name column
 * @method     ChildTeam[]|ObjectCollection findByEmail(string $email) Return ChildTeam objects filtered by the email column
 * @method     ChildTeam[]|ObjectCollection findByLastEmail(int $last_email) Return ChildTeam objects filtered by the last_email column
 * @method     ChildTeam[]|ObjectCollection findByLocOffset(int $loc_offset) Return ChildTeam objects filtered by the loc_offset column
 * @method     ChildTeam[]|ObjectCollection findByTotalDist(int $total_dist) Return ChildTeam objects filtered by the total_dist column
 * @method     ChildTeam[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class TeamQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\TeamQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\Team', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildTeamQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildTeamQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildTeamQuery) {
            return $criteria;
        }
        $query = new ChildTeamQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildTeam|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(TeamTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = TeamTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildTeam A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT team_id, hunt_id, team_pwd, team_name, email, last_email, loc_offset, total_dist FROM nt_team WHERE team_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildTeam $obj */
            $obj = new ChildTeam();
            $obj->hydrate($row);
            TeamTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildTeam|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the team_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTeamID(1234); // WHERE team_id = 1234
     * $query->filterByTeamID(array(12, 34)); // WHERE team_id IN (12, 34)
     * $query->filterByTeamID(array('min' => 12)); // WHERE team_id > 12
     * </code>
     *
     * @param     mixed $teamID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByTeamID($teamID = null, $comparison = null)
    {
        if (is_array($teamID)) {
            $useMinMax = false;
            if (isset($teamID['min'])) {
                $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $teamID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($teamID['max'])) {
                $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $teamID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $teamID, $comparison);
    }

    /**
     * Filter the query on the hunt_id column
     *
     * Example usage:
     * <code>
     * $query->filterByHuntID(1234); // WHERE hunt_id = 1234
     * $query->filterByHuntID(array(12, 34)); // WHERE hunt_id IN (12, 34)
     * $query->filterByHuntID(array('min' => 12)); // WHERE hunt_id > 12
     * </code>
     *
     * @see       filterByHunt()
     *
     * @param     mixed $huntID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByHuntID($huntID = null, $comparison = null)
    {
        if (is_array($huntID)) {
            $useMinMax = false;
            if (isset($huntID['min'])) {
                $this->addUsingAlias(TeamTableMap::COL_HUNT_ID, $huntID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($huntID['max'])) {
                $this->addUsingAlias(TeamTableMap::COL_HUNT_ID, $huntID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_HUNT_ID, $huntID, $comparison);
    }

    /**
     * Filter the query on the team_pwd column
     *
     * Example usage:
     * <code>
     * $query->filterByTeamPWD('fooValue');   // WHERE team_pwd = 'fooValue'
     * $query->filterByTeamPWD('%fooValue%', Criteria::LIKE); // WHERE team_pwd LIKE '%fooValue%'
     * </code>
     *
     * @param     string $teamPWD The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByTeamPWD($teamPWD = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($teamPWD)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_TEAM_PWD, $teamPWD, $comparison);
    }

    /**
     * Filter the query on the team_name column
     *
     * Example usage:
     * <code>
     * $query->filterByTeamName('fooValue');   // WHERE team_name = 'fooValue'
     * $query->filterByTeamName('%fooValue%', Criteria::LIKE); // WHERE team_name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $teamName The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByTeamName($teamName = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($teamName)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_TEAM_NAME, $teamName, $comparison);
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * </code>
     *
     * @param     string $email The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByEmail($email = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_EMAIL, $email, $comparison);
    }

    /**
     * Filter the query on the last_email column
     *
     * Example usage:
     * <code>
     * $query->filterByLastEmail(1234); // WHERE last_email = 1234
     * $query->filterByLastEmail(array(12, 34)); // WHERE last_email IN (12, 34)
     * $query->filterByLastEmail(array('min' => 12)); // WHERE last_email > 12
     * </code>
     *
     * @param     mixed $lastEmail The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByLastEmail($lastEmail = null, $comparison = null)
    {
        if (is_array($lastEmail)) {
            $useMinMax = false;
            if (isset($lastEmail['min'])) {
                $this->addUsingAlias(TeamTableMap::COL_LAST_EMAIL, $lastEmail['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($lastEmail['max'])) {
                $this->addUsingAlias(TeamTableMap::COL_LAST_EMAIL, $lastEmail['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_LAST_EMAIL, $lastEmail, $comparison);
    }

    /**
     * Filter the query on the loc_offset column
     *
     * Example usage:
     * <code>
     * $query->filterByLocOffset(1234); // WHERE loc_offset = 1234
     * $query->filterByLocOffset(array(12, 34)); // WHERE loc_offset IN (12, 34)
     * $query->filterByLocOffset(array('min' => 12)); // WHERE loc_offset > 12
     * </code>
     *
     * @param     mixed $locOffset The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByLocOffset($locOffset = null, $comparison = null)
    {
        if (is_array($locOffset)) {
            $useMinMax = false;
            if (isset($locOffset['min'])) {
                $this->addUsingAlias(TeamTableMap::COL_LOC_OFFSET, $locOffset['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($locOffset['max'])) {
                $this->addUsingAlias(TeamTableMap::COL_LOC_OFFSET, $locOffset['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_LOC_OFFSET, $locOffset, $comparison);
    }

    /**
     * Filter the query on the total_dist column
     *
     * Example usage:
     * <code>
     * $query->filterByTotalDist(1234); // WHERE total_dist = 1234
     * $query->filterByTotalDist(array(12, 34)); // WHERE total_dist IN (12, 34)
     * $query->filterByTotalDist(array('min' => 12)); // WHERE total_dist > 12
     * </code>
     *
     * @param     mixed $totalDist The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function filterByTotalDist($totalDist = null, $comparison = null)
    {
        if (is_array($totalDist)) {
            $useMinMax = false;
            if (isset($totalDist['min'])) {
                $this->addUsingAlias(TeamTableMap::COL_TOTAL_DIST, $totalDist['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($totalDist['max'])) {
                $this->addUsingAlias(TeamTableMap::COL_TOTAL_DIST, $totalDist['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(TeamTableMap::COL_TOTAL_DIST, $totalDist, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\Hunt object
     *
     * @param \Nutty\Models\Hunt|ObjectCollection $hunt The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildTeamQuery The current query, for fluid interface
     */
    public function filterByHunt($hunt, $comparison = null)
    {
        if ($hunt instanceof \Nutty\Models\Hunt) {
            return $this
                ->addUsingAlias(TeamTableMap::COL_HUNT_ID, $hunt->getHuntID(), $comparison);
        } elseif ($hunt instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(TeamTableMap::COL_HUNT_ID, $hunt->toKeyValue('PrimaryKey', 'HuntID'), $comparison);
        } else {
            throw new PropelException('filterByHunt() only accepts arguments of type \Nutty\Models\Hunt or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Hunt relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function joinHunt($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Hunt');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Hunt');
        }

        return $this;
    }

    /**
     * Use the Hunt relation Hunt object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\HuntQuery A secondary query class using the current class as primary query
     */
    public function useHuntQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinHunt($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Hunt', '\Nutty\Models\HuntQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\GameRecord object
     *
     * @param \Nutty\Models\GameRecord|ObjectCollection $gameRecord the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildTeamQuery The current query, for fluid interface
     */
    public function filterByGameRecord($gameRecord, $comparison = null)
    {
        if ($gameRecord instanceof \Nutty\Models\GameRecord) {
            return $this
                ->addUsingAlias(TeamTableMap::COL_TEAM_ID, $gameRecord->getTeamID(), $comparison);
        } elseif ($gameRecord instanceof ObjectCollection) {
            return $this
                ->useGameRecordQuery()
                ->filterByPrimaryKeys($gameRecord->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByGameRecord() only accepts arguments of type \Nutty\Models\GameRecord or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the GameRecord relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function joinGameRecord($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('GameRecord');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'GameRecord');
        }

        return $this;
    }

    /**
     * Use the GameRecord relation GameRecord object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\GameRecordQuery A secondary query class using the current class as primary query
     */
    public function useGameRecordQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinGameRecord($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'GameRecord', '\Nutty\Models\GameRecordQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildTeam $team Object to remove from the list of results
     *
     * @return $this|ChildTeamQuery The current query, for fluid interface
     */
    public function prune($team = null)
    {
        if ($team) {
            $this->addUsingAlias(TeamTableMap::COL_TEAM_ID, $team->getTeamID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_team table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(TeamTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            TeamTableMap::clearInstancePool();
            TeamTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(TeamTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(TeamTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            TeamTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            TeamTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // TeamQuery
