<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\GameRecord as ChildGameRecord;
use Nutty\Models\GameRecordQuery as ChildGameRecordQuery;
use Nutty\Models\Hunt as ChildHunt;
use Nutty\Models\HuntQuery as ChildHuntQuery;
use Nutty\Models\TeamQuery as ChildTeamQuery;
use Nutty\Models\Map\TeamTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the 'nt_team' table.
 *
 *
 *
 * @package    propel.generator.Nutty.Models.Base
 */
abstract class Team implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Nutty\\Models\\Map\\TeamTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the team_id field.
     *
     * @var        int
     */
    protected $team_id;

    /**
     * The value for the hunt_id field.
     *
     * @var        int
     */
    protected $hunt_id;

    /**
     * The value for the team_pwd field.
     *
     * @var        string
     */
    protected $team_pwd;

    /**
     * The value for the team_name field.
     *
     * @var        string
     */
    protected $team_name;

    /**
     * The value for the email field.
     *
     * @var        string
     */
    protected $email;

    /**
     * The value for the last_email field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $last_email;

    /**
     * The value for the loc_offset field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $loc_offset;

    /**
     * The value for the total_dist field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $total_dist;

    /**
     * @var        ChildHunt
     */
    protected $aHunt;

    /**
     * @var        ChildGameRecord one-to-one related ChildGameRecord object
     */
    protected $singleGameRecord;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->last_email = 0;
        $this->loc_offset = 0;
        $this->total_dist = 0;
    }

    /**
     * Initializes internal state of Nutty\Models\Base\Team object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Team</code> instance.  If
     * <code>obj</code> is an instance of <code>Team</code>, delegates to
     * <code>equals(Team)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Team The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [team_id] column value.
     *
     * @return int
     */
    public function getTeamID()
    {
        return $this->team_id;
    }

    /**
     * Get the [hunt_id] column value.
     *
     * @return int
     */
    public function getHuntID()
    {
        return $this->hunt_id;
    }

    /**
     * Get the [team_pwd] column value.
     *
     * @return string
     */
    public function getTeamPWD()
    {
        return $this->team_pwd;
    }

    /**
     * Get the [team_name] column value.
     *
     * @return string
     */
    public function getTeamName()
    {
        return $this->team_name;
    }

    /**
     * Get the [email] column value.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [last_email] column value.
     *
     * @return int
     */
    public function getLastEmail()
    {
        return $this->last_email;
    }

    /**
     * Get the [loc_offset] column value.
     *
     * @return int
     */
    public function getLocOffset()
    {
        return $this->loc_offset;
    }

    /**
     * Get the [total_dist] column value.
     *
     * @return int
     */
    public function getTotalDist()
    {
        return $this->total_dist;
    }

    /**
     * Set the value of [team_id] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setTeamID($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->team_id !== $v) {
            $this->team_id = $v;
            $this->modifiedColumns[TeamTableMap::COL_TEAM_ID] = true;
        }

        return $this;
    } // setTeamID()

    /**
     * Set the value of [hunt_id] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setHuntID($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->hunt_id !== $v) {
            $this->hunt_id = $v;
            $this->modifiedColumns[TeamTableMap::COL_HUNT_ID] = true;
        }

        if ($this->aHunt !== null && $this->aHunt->getHuntID() !== $v) {
            $this->aHunt = null;
        }

        return $this;
    } // setHuntID()

    /**
     * Set the value of [team_pwd] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setTeamPWD($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->team_pwd !== $v) {
            $this->team_pwd = $v;
            $this->modifiedColumns[TeamTableMap::COL_TEAM_PWD] = true;
        }

        return $this;
    } // setTeamPWD()

    /**
     * Set the value of [team_name] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setTeamName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->team_name !== $v) {
            $this->team_name = $v;
            $this->modifiedColumns[TeamTableMap::COL_TEAM_NAME] = true;
        }

        return $this;
    } // setTeamName()

    /**
     * Set the value of [email] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[TeamTableMap::COL_EMAIL] = true;
        }

        return $this;
    } // setEmail()

    /**
     * Set the value of [last_email] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setLastEmail($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->last_email !== $v) {
            $this->last_email = $v;
            $this->modifiedColumns[TeamTableMap::COL_LAST_EMAIL] = true;
        }

        return $this;
    } // setLastEmail()

    /**
     * Set the value of [loc_offset] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setLocOffset($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->loc_offset !== $v) {
            $this->loc_offset = $v;
            $this->modifiedColumns[TeamTableMap::COL_LOC_OFFSET] = true;
        }

        return $this;
    } // setLocOffset()

    /**
     * Set the value of [total_dist] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     */
    public function setTotalDist($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->total_dist !== $v) {
            $this->total_dist = $v;
            $this->modifiedColumns[TeamTableMap::COL_TOTAL_DIST] = true;
        }

        return $this;
    } // setTotalDist()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->last_email !== 0) {
                return false;
            }

            if ($this->loc_offset !== 0) {
                return false;
            }

            if ($this->total_dist !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : TeamTableMap::translateFieldName('TeamID', TableMap::TYPE_PHPNAME, $indexType)];
            $this->team_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : TeamTableMap::translateFieldName('HuntID', TableMap::TYPE_PHPNAME, $indexType)];
            $this->hunt_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : TeamTableMap::translateFieldName('TeamPWD', TableMap::TYPE_PHPNAME, $indexType)];
            $this->team_pwd = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : TeamTableMap::translateFieldName('TeamName', TableMap::TYPE_PHPNAME, $indexType)];
            $this->team_name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : TeamTableMap::translateFieldName('Email', TableMap::TYPE_PHPNAME, $indexType)];
            $this->email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : TeamTableMap::translateFieldName('LastEmail', TableMap::TYPE_PHPNAME, $indexType)];
            $this->last_email = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : TeamTableMap::translateFieldName('LocOffset', TableMap::TYPE_PHPNAME, $indexType)];
            $this->loc_offset = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : TeamTableMap::translateFieldName('TotalDist', TableMap::TYPE_PHPNAME, $indexType)];
            $this->total_dist = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 8; // 8 = TeamTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Nutty\\Models\\Team'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aHunt !== null && $this->hunt_id !== $this->aHunt->getHuntID()) {
            $this->aHunt = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(TeamTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildTeamQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aHunt = null;
            $this->singleGameRecord = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Team::setDeleted()
     * @see Team::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(TeamTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildTeamQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(TeamTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                TeamTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aHunt !== null) {
                if ($this->aHunt->isModified() || $this->aHunt->isNew()) {
                    $affectedRows += $this->aHunt->save($con);
                }
                $this->setHunt($this->aHunt);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->singleGameRecord !== null) {
                if (!$this->singleGameRecord->isDeleted() && ($this->singleGameRecord->isNew() || $this->singleGameRecord->isModified())) {
                    $affectedRows += $this->singleGameRecord->save($con);
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[TeamTableMap::COL_TEAM_ID] = true;
        if (null !== $this->team_id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . TeamTableMap::COL_TEAM_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(TeamTableMap::COL_TEAM_ID)) {
            $modifiedColumns[':p' . $index++]  = 'team_id';
        }
        if ($this->isColumnModified(TeamTableMap::COL_HUNT_ID)) {
            $modifiedColumns[':p' . $index++]  = 'hunt_id';
        }
        if ($this->isColumnModified(TeamTableMap::COL_TEAM_PWD)) {
            $modifiedColumns[':p' . $index++]  = 'team_pwd';
        }
        if ($this->isColumnModified(TeamTableMap::COL_TEAM_NAME)) {
            $modifiedColumns[':p' . $index++]  = 'team_name';
        }
        if ($this->isColumnModified(TeamTableMap::COL_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = 'email';
        }
        if ($this->isColumnModified(TeamTableMap::COL_LAST_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = 'last_email';
        }
        if ($this->isColumnModified(TeamTableMap::COL_LOC_OFFSET)) {
            $modifiedColumns[':p' . $index++]  = 'loc_offset';
        }
        if ($this->isColumnModified(TeamTableMap::COL_TOTAL_DIST)) {
            $modifiedColumns[':p' . $index++]  = 'total_dist';
        }

        $sql = sprintf(
            'INSERT INTO nt_team (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case 'team_id':
                        $stmt->bindValue($identifier, $this->team_id, PDO::PARAM_INT);
                        break;
                    case 'hunt_id':
                        $stmt->bindValue($identifier, $this->hunt_id, PDO::PARAM_INT);
                        break;
                    case 'team_pwd':
                        $stmt->bindValue($identifier, $this->team_pwd, PDO::PARAM_STR);
                        break;
                    case 'team_name':
                        $stmt->bindValue($identifier, $this->team_name, PDO::PARAM_STR);
                        break;
                    case 'email':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case 'last_email':
                        $stmt->bindValue($identifier, $this->last_email, PDO::PARAM_INT);
                        break;
                    case 'loc_offset':
                        $stmt->bindValue($identifier, $this->loc_offset, PDO::PARAM_INT);
                        break;
                    case 'total_dist':
                        $stmt->bindValue($identifier, $this->total_dist, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setTeamID($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = TeamTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getTeamID();
                break;
            case 1:
                return $this->getHuntID();
                break;
            case 2:
                return $this->getTeamPWD();
                break;
            case 3:
                return $this->getTeamName();
                break;
            case 4:
                return $this->getEmail();
                break;
            case 5:
                return $this->getLastEmail();
                break;
            case 6:
                return $this->getLocOffset();
                break;
            case 7:
                return $this->getTotalDist();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Team'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Team'][$this->hashCode()] = true;
        $keys = TeamTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getTeamID(),
            $keys[1] => $this->getHuntID(),
            $keys[2] => $this->getTeamPWD(),
            $keys[3] => $this->getTeamName(),
            $keys[4] => $this->getEmail(),
            $keys[5] => $this->getLastEmail(),
            $keys[6] => $this->getLocOffset(),
            $keys[7] => $this->getTotalDist(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aHunt) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'hunt';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_hunt';
                        break;
                    default:
                        $key = 'Hunt';
                }

                $result[$key] = $this->aHunt->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleGameRecord) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'gameRecord';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_game_record';
                        break;
                    default:
                        $key = 'GameRecord';
                }

                $result[$key] = $this->singleGameRecord->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Nutty\Models\Team
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = TeamTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Nutty\Models\Team
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setTeamID($value);
                break;
            case 1:
                $this->setHuntID($value);
                break;
            case 2:
                $this->setTeamPWD($value);
                break;
            case 3:
                $this->setTeamName($value);
                break;
            case 4:
                $this->setEmail($value);
                break;
            case 5:
                $this->setLastEmail($value);
                break;
            case 6:
                $this->setLocOffset($value);
                break;
            case 7:
                $this->setTotalDist($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = TeamTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setTeamID($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setHuntID($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setTeamPWD($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setTeamName($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setEmail($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setLastEmail($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setLocOffset($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setTotalDist($arr[$keys[7]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Nutty\Models\Team The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(TeamTableMap::DATABASE_NAME);

        if ($this->isColumnModified(TeamTableMap::COL_TEAM_ID)) {
            $criteria->add(TeamTableMap::COL_TEAM_ID, $this->team_id);
        }
        if ($this->isColumnModified(TeamTableMap::COL_HUNT_ID)) {
            $criteria->add(TeamTableMap::COL_HUNT_ID, $this->hunt_id);
        }
        if ($this->isColumnModified(TeamTableMap::COL_TEAM_PWD)) {
            $criteria->add(TeamTableMap::COL_TEAM_PWD, $this->team_pwd);
        }
        if ($this->isColumnModified(TeamTableMap::COL_TEAM_NAME)) {
            $criteria->add(TeamTableMap::COL_TEAM_NAME, $this->team_name);
        }
        if ($this->isColumnModified(TeamTableMap::COL_EMAIL)) {
            $criteria->add(TeamTableMap::COL_EMAIL, $this->email);
        }
        if ($this->isColumnModified(TeamTableMap::COL_LAST_EMAIL)) {
            $criteria->add(TeamTableMap::COL_LAST_EMAIL, $this->last_email);
        }
        if ($this->isColumnModified(TeamTableMap::COL_LOC_OFFSET)) {
            $criteria->add(TeamTableMap::COL_LOC_OFFSET, $this->loc_offset);
        }
        if ($this->isColumnModified(TeamTableMap::COL_TOTAL_DIST)) {
            $criteria->add(TeamTableMap::COL_TOTAL_DIST, $this->total_dist);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildTeamQuery::create();
        $criteria->add(TeamTableMap::COL_TEAM_ID, $this->team_id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getTeamID();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getTeamID();
    }

    /**
     * Generic method to set the primary key (team_id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setTeamID($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getTeamID();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Nutty\Models\Team (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setHuntID($this->getHuntID());
        $copyObj->setTeamPWD($this->getTeamPWD());
        $copyObj->setTeamName($this->getTeamName());
        $copyObj->setEmail($this->getEmail());
        $copyObj->setLastEmail($this->getLastEmail());
        $copyObj->setLocOffset($this->getLocOffset());
        $copyObj->setTotalDist($this->getTotalDist());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            $relObj = $this->getGameRecord();
            if ($relObj) {
                $copyObj->setGameRecord($relObj->copy($deepCopy));
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setTeamID(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Nutty\Models\Team Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a ChildHunt object.
     *
     * @param  ChildHunt $v
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     * @throws PropelException
     */
    public function setHunt(ChildHunt $v = null)
    {
        if ($v === null) {
            $this->setHuntID(NULL);
        } else {
            $this->setHuntID($v->getHuntID());
        }

        $this->aHunt = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ChildHunt object, it will not be re-added.
        if ($v !== null) {
            $v->addTeam($this);
        }


        return $this;
    }


    /**
     * Get the associated ChildHunt object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return ChildHunt The associated ChildHunt object.
     * @throws PropelException
     */
    public function getHunt(ConnectionInterface $con = null)
    {
        if ($this->aHunt === null && ($this->hunt_id !== null)) {
            $this->aHunt = ChildHuntQuery::create()->findPk($this->hunt_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aHunt->addTeams($this);
             */
        }

        return $this->aHunt;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
    }

    /**
     * Gets a single ChildGameRecord object, which is related to this object by a one-to-one relationship.
     *
     * @param  ConnectionInterface $con optional connection object
     * @return ChildGameRecord
     * @throws PropelException
     */
    public function getGameRecord(ConnectionInterface $con = null)
    {

        if ($this->singleGameRecord === null && !$this->isNew()) {
            $this->singleGameRecord = ChildGameRecordQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleGameRecord;
    }

    /**
     * Sets a single ChildGameRecord object as related to this object by a one-to-one relationship.
     *
     * @param  ChildGameRecord $v ChildGameRecord
     * @return $this|\Nutty\Models\Team The current object (for fluent API support)
     * @throws PropelException
     */
    public function setGameRecord(ChildGameRecord $v = null)
    {
        $this->singleGameRecord = $v;

        // Make sure that that the passed-in ChildGameRecord isn't already associated with this object
        if ($v !== null && $v->getTeam(null, false) === null) {
            $v->setTeam($this);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aHunt) {
            $this->aHunt->removeTeam($this);
        }
        $this->team_id = null;
        $this->hunt_id = null;
        $this->team_pwd = null;
        $this->team_name = null;
        $this->email = null;
        $this->last_email = null;
        $this->loc_offset = null;
        $this->total_dist = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->singleGameRecord) {
                $this->singleGameRecord->clearAllReferences($deep);
            }
        } // if ($deep)

        $this->singleGameRecord = null;
        $this->aHunt = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(TeamTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
