<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\Staff as ChildStaff;
use Nutty\Models\StaffQuery as ChildStaffQuery;
use Nutty\Models\Map\StaffTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_staff' table.
 *
 *
 *
 * @method     ChildStaffQuery orderByStaffID($order = Criteria::ASC) Order by the staff_id column
 * @method     ChildStaffQuery orderByEmail($order = Criteria::ASC) Order by the email column
 * @method     ChildStaffQuery orderByPassword($order = Criteria::ASC) Order by the password column
 * @method     ChildStaffQuery orderByToken($order = Criteria::ASC) Order by the token column
 * @method     ChildStaffQuery orderBySalt($order = Criteria::ASC) Order by the salt column
 *
 * @method     ChildStaffQuery groupByStaffID() Group by the staff_id column
 * @method     ChildStaffQuery groupByEmail() Group by the email column
 * @method     ChildStaffQuery groupByPassword() Group by the password column
 * @method     ChildStaffQuery groupByToken() Group by the token column
 * @method     ChildStaffQuery groupBySalt() Group by the salt column
 *
 * @method     ChildStaffQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildStaffQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildStaffQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildStaffQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildStaffQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildStaffQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildStaffQuery leftJoinLocationTemplate($relationAlias = null) Adds a LEFT JOIN clause to the query using the LocationTemplate relation
 * @method     ChildStaffQuery rightJoinLocationTemplate($relationAlias = null) Adds a RIGHT JOIN clause to the query using the LocationTemplate relation
 * @method     ChildStaffQuery innerJoinLocationTemplate($relationAlias = null) Adds a INNER JOIN clause to the query using the LocationTemplate relation
 *
 * @method     ChildStaffQuery joinWithLocationTemplate($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the LocationTemplate relation
 *
 * @method     ChildStaffQuery leftJoinWithLocationTemplate() Adds a LEFT JOIN clause and with to the query using the LocationTemplate relation
 * @method     ChildStaffQuery rightJoinWithLocationTemplate() Adds a RIGHT JOIN clause and with to the query using the LocationTemplate relation
 * @method     ChildStaffQuery innerJoinWithLocationTemplate() Adds a INNER JOIN clause and with to the query using the LocationTemplate relation
 *
 * @method     ChildStaffQuery leftJoinHunt($relationAlias = null) Adds a LEFT JOIN clause to the query using the Hunt relation
 * @method     ChildStaffQuery rightJoinHunt($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Hunt relation
 * @method     ChildStaffQuery innerJoinHunt($relationAlias = null) Adds a INNER JOIN clause to the query using the Hunt relation
 *
 * @method     ChildStaffQuery joinWithHunt($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Hunt relation
 *
 * @method     ChildStaffQuery leftJoinWithHunt() Adds a LEFT JOIN clause and with to the query using the Hunt relation
 * @method     ChildStaffQuery rightJoinWithHunt() Adds a RIGHT JOIN clause and with to the query using the Hunt relation
 * @method     ChildStaffQuery innerJoinWithHunt() Adds a INNER JOIN clause and with to the query using the Hunt relation
 *
 * @method     \Nutty\Models\LocationTemplateQuery|\Nutty\Models\HuntQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildStaff findOne(ConnectionInterface $con = null) Return the first ChildStaff matching the query
 * @method     ChildStaff findOneOrCreate(ConnectionInterface $con = null) Return the first ChildStaff matching the query, or a new ChildStaff object populated from the query conditions when no match is found
 *
 * @method     ChildStaff findOneByStaffID(int $staff_id) Return the first ChildStaff filtered by the staff_id column
 * @method     ChildStaff findOneByEmail(string $email) Return the first ChildStaff filtered by the email column
 * @method     ChildStaff findOneByPassword(string $password) Return the first ChildStaff filtered by the password column
 * @method     ChildStaff findOneByToken(string $token) Return the first ChildStaff filtered by the token column
 * @method     ChildStaff findOneBySalt(string $salt) Return the first ChildStaff filtered by the salt column *

 * @method     ChildStaff requirePk($key, ConnectionInterface $con = null) Return the ChildStaff by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStaff requireOne(ConnectionInterface $con = null) Return the first ChildStaff matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStaff requireOneByStaffID(int $staff_id) Return the first ChildStaff filtered by the staff_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStaff requireOneByEmail(string $email) Return the first ChildStaff filtered by the email column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStaff requireOneByPassword(string $password) Return the first ChildStaff filtered by the password column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStaff requireOneByToken(string $token) Return the first ChildStaff filtered by the token column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildStaff requireOneBySalt(string $salt) Return the first ChildStaff filtered by the salt column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildStaff[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildStaff objects based on current ModelCriteria
 * @method     ChildStaff[]|ObjectCollection findByStaffID(int $staff_id) Return ChildStaff objects filtered by the staff_id column
 * @method     ChildStaff[]|ObjectCollection findByEmail(string $email) Return ChildStaff objects filtered by the email column
 * @method     ChildStaff[]|ObjectCollection findByPassword(string $password) Return ChildStaff objects filtered by the password column
 * @method     ChildStaff[]|ObjectCollection findByToken(string $token) Return ChildStaff objects filtered by the token column
 * @method     ChildStaff[]|ObjectCollection findBySalt(string $salt) Return ChildStaff objects filtered by the salt column
 * @method     ChildStaff[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class StaffQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\StaffQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\Staff', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildStaffQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildStaffQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildStaffQuery) {
            return $criteria;
        }
        $query = new ChildStaffQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildStaff|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StaffTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = StaffTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildStaff A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT staff_id, email, password, token, salt FROM nt_staff WHERE staff_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildStaff $obj */
            $obj = new ChildStaff();
            $obj->hydrate($row);
            StaffTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildStaff|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the staff_id column
     *
     * Example usage:
     * <code>
     * $query->filterByStaffID(1234); // WHERE staff_id = 1234
     * $query->filterByStaffID(array(12, 34)); // WHERE staff_id IN (12, 34)
     * $query->filterByStaffID(array('min' => 12)); // WHERE staff_id > 12
     * </code>
     *
     * @param     mixed $staffID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByStaffID($staffID = null, $comparison = null)
    {
        if (is_array($staffID)) {
            $useMinMax = false;
            if (isset($staffID['min'])) {
                $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $staffID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($staffID['max'])) {
                $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $staffID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $staffID, $comparison);
    }

    /**
     * Filter the query on the email column
     *
     * Example usage:
     * <code>
     * $query->filterByEmail('fooValue');   // WHERE email = 'fooValue'
     * $query->filterByEmail('%fooValue%', Criteria::LIKE); // WHERE email LIKE '%fooValue%'
     * </code>
     *
     * @param     string $email The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByEmail($email = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($email)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StaffTableMap::COL_EMAIL, $email, $comparison);
    }

    /**
     * Filter the query on the password column
     *
     * Example usage:
     * <code>
     * $query->filterByPassword('fooValue');   // WHERE password = 'fooValue'
     * $query->filterByPassword('%fooValue%', Criteria::LIKE); // WHERE password LIKE '%fooValue%'
     * </code>
     *
     * @param     string $password The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByPassword($password = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($password)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StaffTableMap::COL_PASSWORD, $password, $comparison);
    }

    /**
     * Filter the query on the token column
     *
     * Example usage:
     * <code>
     * $query->filterByToken('fooValue');   // WHERE token = 'fooValue'
     * $query->filterByToken('%fooValue%', Criteria::LIKE); // WHERE token LIKE '%fooValue%'
     * </code>
     *
     * @param     string $token The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterByToken($token = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($token)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StaffTableMap::COL_TOKEN, $token, $comparison);
    }

    /**
     * Filter the query on the salt column
     *
     * Example usage:
     * <code>
     * $query->filterBySalt('fooValue');   // WHERE salt = 'fooValue'
     * $query->filterBySalt('%fooValue%', Criteria::LIKE); // WHERE salt LIKE '%fooValue%'
     * </code>
     *
     * @param     string $salt The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function filterBySalt($salt = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($salt)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(StaffTableMap::COL_SALT, $salt, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\LocationTemplate object
     *
     * @param \Nutty\Models\LocationTemplate|ObjectCollection $locationTemplate the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStaffQuery The current query, for fluid interface
     */
    public function filterByLocationTemplate($locationTemplate, $comparison = null)
    {
        if ($locationTemplate instanceof \Nutty\Models\LocationTemplate) {
            return $this
                ->addUsingAlias(StaffTableMap::COL_STAFF_ID, $locationTemplate->getCreatorID(), $comparison);
        } elseif ($locationTemplate instanceof ObjectCollection) {
            return $this
                ->useLocationTemplateQuery()
                ->filterByPrimaryKeys($locationTemplate->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByLocationTemplate() only accepts arguments of type \Nutty\Models\LocationTemplate or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the LocationTemplate relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function joinLocationTemplate($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('LocationTemplate');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'LocationTemplate');
        }

        return $this;
    }

    /**
     * Use the LocationTemplate relation LocationTemplate object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\LocationTemplateQuery A secondary query class using the current class as primary query
     */
    public function useLocationTemplateQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinLocationTemplate($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'LocationTemplate', '\Nutty\Models\LocationTemplateQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\Hunt object
     *
     * @param \Nutty\Models\Hunt|ObjectCollection $hunt the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildStaffQuery The current query, for fluid interface
     */
    public function filterByHunt($hunt, $comparison = null)
    {
        if ($hunt instanceof \Nutty\Models\Hunt) {
            return $this
                ->addUsingAlias(StaffTableMap::COL_STAFF_ID, $hunt->getCreatorID(), $comparison);
        } elseif ($hunt instanceof ObjectCollection) {
            return $this
                ->useHuntQuery()
                ->filterByPrimaryKeys($hunt->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByHunt() only accepts arguments of type \Nutty\Models\Hunt or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Hunt relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function joinHunt($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Hunt');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Hunt');
        }

        return $this;
    }

    /**
     * Use the Hunt relation Hunt object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\HuntQuery A secondary query class using the current class as primary query
     */
    public function useHuntQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinHunt($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Hunt', '\Nutty\Models\HuntQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildStaff $staff Object to remove from the list of results
     *
     * @return $this|ChildStaffQuery The current query, for fluid interface
     */
    public function prune($staff = null)
    {
        if ($staff) {
            $this->addUsingAlias(StaffTableMap::COL_STAFF_ID, $staff->getStaffID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_staff table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StaffTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            StaffTableMap::clearInstancePool();
            StaffTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(StaffTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(StaffTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            StaffTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            StaffTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // StaffQuery
