<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\Hunt as ChildHunt;
use Nutty\Models\HuntQuery as ChildHuntQuery;
use Nutty\Models\LocationTemplate as ChildLocationTemplate;
use Nutty\Models\LocationTemplateQuery as ChildLocationTemplateQuery;
use Nutty\Models\Staff as ChildStaff;
use Nutty\Models\StaffQuery as ChildStaffQuery;
use Nutty\Models\Map\HuntTableMap;
use Nutty\Models\Map\LocationTemplateTableMap;
use Nutty\Models\Map\StaffTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the 'nt_staff' table.
 *
 *
 *
 * @package    propel.generator.Nutty.Models.Base
 */
abstract class Staff implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Nutty\\Models\\Map\\StaffTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the staff_id field.
     *
     * @var        int
     */
    protected $staff_id;

    /**
     * The value for the email field.
     *
     * @var        string
     */
    protected $email;

    /**
     * The value for the password field.
     *
     * @var        string
     */
    protected $password;

    /**
     * The value for the token field.
     *
     * @var        string
     */
    protected $token;

    /**
     * The value for the salt field.
     *
     * @var        string
     */
    protected $salt;

    /**
     * @var        ObjectCollection|ChildLocationTemplate[] Collection to store aggregation of ChildLocationTemplate objects.
     */
    protected $collLocationTemplates;
    protected $collLocationTemplatesPartial;

    /**
     * @var        ObjectCollection|ChildHunt[] Collection to store aggregation of ChildHunt objects.
     */
    protected $collHunts;
    protected $collHuntsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildLocationTemplate[]
     */
    protected $locationTemplatesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildHunt[]
     */
    protected $huntsScheduledForDeletion = null;

    /**
     * Initializes internal state of Nutty\Models\Base\Staff object.
     */
    public function __construct()
    {
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Staff</code> instance.  If
     * <code>obj</code> is an instance of <code>Staff</code>, delegates to
     * <code>equals(Staff)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Staff The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [staff_id] column value.
     *
     * @return int
     */
    public function getStaffID()
    {
        return $this->staff_id;
    }

    /**
     * Get the [email] column value.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [password] column value.
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [token] column value.
     *
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * Get the [salt] column value.
     *
     * @return string
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * Set the value of [staff_id] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function setStaffID($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->staff_id !== $v) {
            $this->staff_id = $v;
            $this->modifiedColumns[StaffTableMap::COL_STAFF_ID] = true;
        }

        return $this;
    } // setStaffID()

    /**
     * Set the value of [email] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[StaffTableMap::COL_EMAIL] = true;
        }

        return $this;
    } // setEmail()

    /**
     * Set the value of [password] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[StaffTableMap::COL_PASSWORD] = true;
        }

        return $this;
    } // setPassword()

    /**
     * Set the value of [token] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function setToken($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->token !== $v) {
            $this->token = $v;
            $this->modifiedColumns[StaffTableMap::COL_TOKEN] = true;
        }

        return $this;
    } // setToken()

    /**
     * Set the value of [salt] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function setSalt($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->salt !== $v) {
            $this->salt = $v;
            $this->modifiedColumns[StaffTableMap::COL_SALT] = true;
        }

        return $this;
    } // setSalt()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : StaffTableMap::translateFieldName('StaffID', TableMap::TYPE_PHPNAME, $indexType)];
            $this->staff_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : StaffTableMap::translateFieldName('Email', TableMap::TYPE_PHPNAME, $indexType)];
            $this->email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : StaffTableMap::translateFieldName('Password', TableMap::TYPE_PHPNAME, $indexType)];
            $this->password = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : StaffTableMap::translateFieldName('Token', TableMap::TYPE_PHPNAME, $indexType)];
            $this->token = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : StaffTableMap::translateFieldName('Salt', TableMap::TYPE_PHPNAME, $indexType)];
            $this->salt = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 5; // 5 = StaffTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Nutty\\Models\\Staff'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(StaffTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildStaffQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->collLocationTemplates = null;

            $this->collHunts = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Staff::setDeleted()
     * @see Staff::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StaffTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildStaffQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(StaffTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                StaffTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->locationTemplatesScheduledForDeletion !== null) {
                if (!$this->locationTemplatesScheduledForDeletion->isEmpty()) {
                    \Nutty\Models\LocationTemplateQuery::create()
                        ->filterByPrimaryKeys($this->locationTemplatesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->locationTemplatesScheduledForDeletion = null;
                }
            }

            if ($this->collLocationTemplates !== null) {
                foreach ($this->collLocationTemplates as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->huntsScheduledForDeletion !== null) {
                if (!$this->huntsScheduledForDeletion->isEmpty()) {
                    \Nutty\Models\HuntQuery::create()
                        ->filterByPrimaryKeys($this->huntsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->huntsScheduledForDeletion = null;
                }
            }

            if ($this->collHunts !== null) {
                foreach ($this->collHunts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[StaffTableMap::COL_STAFF_ID] = true;
        if (null !== $this->staff_id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . StaffTableMap::COL_STAFF_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(StaffTableMap::COL_STAFF_ID)) {
            $modifiedColumns[':p' . $index++]  = 'staff_id';
        }
        if ($this->isColumnModified(StaffTableMap::COL_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = 'email';
        }
        if ($this->isColumnModified(StaffTableMap::COL_PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = 'password';
        }
        if ($this->isColumnModified(StaffTableMap::COL_TOKEN)) {
            $modifiedColumns[':p' . $index++]  = 'token';
        }
        if ($this->isColumnModified(StaffTableMap::COL_SALT)) {
            $modifiedColumns[':p' . $index++]  = 'salt';
        }

        $sql = sprintf(
            'INSERT INTO nt_staff (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case 'staff_id':
                        $stmt->bindValue($identifier, $this->staff_id, PDO::PARAM_INT);
                        break;
                    case 'email':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case 'password':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case 'token':
                        $stmt->bindValue($identifier, $this->token, PDO::PARAM_STR);
                        break;
                    case 'salt':
                        $stmt->bindValue($identifier, $this->salt, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setStaffID($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StaffTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getStaffID();
                break;
            case 1:
                return $this->getEmail();
                break;
            case 2:
                return $this->getPassword();
                break;
            case 3:
                return $this->getToken();
                break;
            case 4:
                return $this->getSalt();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Staff'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Staff'][$this->hashCode()] = true;
        $keys = StaffTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getStaffID(),
            $keys[1] => $this->getEmail(),
            $keys[2] => $this->getPassword(),
            $keys[3] => $this->getToken(),
            $keys[4] => $this->getSalt(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->collLocationTemplates) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'locationTemplates';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_location_templates';
                        break;
                    default:
                        $key = 'LocationTemplates';
                }

                $result[$key] = $this->collLocationTemplates->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collHunts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'hunts';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_hunts';
                        break;
                    default:
                        $key = 'Hunts';
                }

                $result[$key] = $this->collHunts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Nutty\Models\Staff
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = StaffTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Nutty\Models\Staff
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setStaffID($value);
                break;
            case 1:
                $this->setEmail($value);
                break;
            case 2:
                $this->setPassword($value);
                break;
            case 3:
                $this->setToken($value);
                break;
            case 4:
                $this->setSalt($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = StaffTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setStaffID($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setEmail($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setPassword($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setToken($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setSalt($arr[$keys[4]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Nutty\Models\Staff The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(StaffTableMap::DATABASE_NAME);

        if ($this->isColumnModified(StaffTableMap::COL_STAFF_ID)) {
            $criteria->add(StaffTableMap::COL_STAFF_ID, $this->staff_id);
        }
        if ($this->isColumnModified(StaffTableMap::COL_EMAIL)) {
            $criteria->add(StaffTableMap::COL_EMAIL, $this->email);
        }
        if ($this->isColumnModified(StaffTableMap::COL_PASSWORD)) {
            $criteria->add(StaffTableMap::COL_PASSWORD, $this->password);
        }
        if ($this->isColumnModified(StaffTableMap::COL_TOKEN)) {
            $criteria->add(StaffTableMap::COL_TOKEN, $this->token);
        }
        if ($this->isColumnModified(StaffTableMap::COL_SALT)) {
            $criteria->add(StaffTableMap::COL_SALT, $this->salt);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildStaffQuery::create();
        $criteria->add(StaffTableMap::COL_STAFF_ID, $this->staff_id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getStaffID();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getStaffID();
    }

    /**
     * Generic method to set the primary key (staff_id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setStaffID($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getStaffID();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Nutty\Models\Staff (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setEmail($this->getEmail());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setToken($this->getToken());
        $copyObj->setSalt($this->getSalt());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getLocationTemplates() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addLocationTemplate($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getHunts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addHunt($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setStaffID(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Nutty\Models\Staff Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('LocationTemplate' == $relationName) {
            return $this->initLocationTemplates();
        }
        if ('Hunt' == $relationName) {
            return $this->initHunts();
        }
    }

    /**
     * Clears out the collLocationTemplates collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addLocationTemplates()
     */
    public function clearLocationTemplates()
    {
        $this->collLocationTemplates = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collLocationTemplates collection loaded partially.
     */
    public function resetPartialLocationTemplates($v = true)
    {
        $this->collLocationTemplatesPartial = $v;
    }

    /**
     * Initializes the collLocationTemplates collection.
     *
     * By default this just sets the collLocationTemplates collection to an empty array (like clearcollLocationTemplates());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initLocationTemplates($overrideExisting = true)
    {
        if (null !== $this->collLocationTemplates && !$overrideExisting) {
            return;
        }

        $collectionClassName = LocationTemplateTableMap::getTableMap()->getCollectionClassName();

        $this->collLocationTemplates = new $collectionClassName;
        $this->collLocationTemplates->setModel('\Nutty\Models\LocationTemplate');
    }

    /**
     * Gets an array of ChildLocationTemplate objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildStaff is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildLocationTemplate[] List of ChildLocationTemplate objects
     * @throws PropelException
     */
    public function getLocationTemplates(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collLocationTemplatesPartial && !$this->isNew();
        if (null === $this->collLocationTemplates || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collLocationTemplates) {
                // return empty collection
                $this->initLocationTemplates();
            } else {
                $collLocationTemplates = ChildLocationTemplateQuery::create(null, $criteria)
                    ->filterByStaff($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collLocationTemplatesPartial && count($collLocationTemplates)) {
                        $this->initLocationTemplates(false);

                        foreach ($collLocationTemplates as $obj) {
                            if (false == $this->collLocationTemplates->contains($obj)) {
                                $this->collLocationTemplates->append($obj);
                            }
                        }

                        $this->collLocationTemplatesPartial = true;
                    }

                    return $collLocationTemplates;
                }

                if ($partial && $this->collLocationTemplates) {
                    foreach ($this->collLocationTemplates as $obj) {
                        if ($obj->isNew()) {
                            $collLocationTemplates[] = $obj;
                        }
                    }
                }

                $this->collLocationTemplates = $collLocationTemplates;
                $this->collLocationTemplatesPartial = false;
            }
        }

        return $this->collLocationTemplates;
    }

    /**
     * Sets a collection of ChildLocationTemplate objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $locationTemplates A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildStaff The current object (for fluent API support)
     */
    public function setLocationTemplates(Collection $locationTemplates, ConnectionInterface $con = null)
    {
        /** @var ChildLocationTemplate[] $locationTemplatesToDelete */
        $locationTemplatesToDelete = $this->getLocationTemplates(new Criteria(), $con)->diff($locationTemplates);


        $this->locationTemplatesScheduledForDeletion = $locationTemplatesToDelete;

        foreach ($locationTemplatesToDelete as $locationTemplateRemoved) {
            $locationTemplateRemoved->setStaff(null);
        }

        $this->collLocationTemplates = null;
        foreach ($locationTemplates as $locationTemplate) {
            $this->addLocationTemplate($locationTemplate);
        }

        $this->collLocationTemplates = $locationTemplates;
        $this->collLocationTemplatesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related LocationTemplate objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related LocationTemplate objects.
     * @throws PropelException
     */
    public function countLocationTemplates(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collLocationTemplatesPartial && !$this->isNew();
        if (null === $this->collLocationTemplates || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collLocationTemplates) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getLocationTemplates());
            }

            $query = ChildLocationTemplateQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByStaff($this)
                ->count($con);
        }

        return count($this->collLocationTemplates);
    }

    /**
     * Method called to associate a ChildLocationTemplate object to this object
     * through the ChildLocationTemplate foreign key attribute.
     *
     * @param  ChildLocationTemplate $l ChildLocationTemplate
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function addLocationTemplate(ChildLocationTemplate $l)
    {
        if ($this->collLocationTemplates === null) {
            $this->initLocationTemplates();
            $this->collLocationTemplatesPartial = true;
        }

        if (!$this->collLocationTemplates->contains($l)) {
            $this->doAddLocationTemplate($l);

            if ($this->locationTemplatesScheduledForDeletion and $this->locationTemplatesScheduledForDeletion->contains($l)) {
                $this->locationTemplatesScheduledForDeletion->remove($this->locationTemplatesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildLocationTemplate $locationTemplate The ChildLocationTemplate object to add.
     */
    protected function doAddLocationTemplate(ChildLocationTemplate $locationTemplate)
    {
        $this->collLocationTemplates[]= $locationTemplate;
        $locationTemplate->setStaff($this);
    }

    /**
     * @param  ChildLocationTemplate $locationTemplate The ChildLocationTemplate object to remove.
     * @return $this|ChildStaff The current object (for fluent API support)
     */
    public function removeLocationTemplate(ChildLocationTemplate $locationTemplate)
    {
        if ($this->getLocationTemplates()->contains($locationTemplate)) {
            $pos = $this->collLocationTemplates->search($locationTemplate);
            $this->collLocationTemplates->remove($pos);
            if (null === $this->locationTemplatesScheduledForDeletion) {
                $this->locationTemplatesScheduledForDeletion = clone $this->collLocationTemplates;
                $this->locationTemplatesScheduledForDeletion->clear();
            }
            $this->locationTemplatesScheduledForDeletion[]= clone $locationTemplate;
            $locationTemplate->setStaff(null);
        }

        return $this;
    }

    /**
     * Clears out the collHunts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addHunts()
     */
    public function clearHunts()
    {
        $this->collHunts = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collHunts collection loaded partially.
     */
    public function resetPartialHunts($v = true)
    {
        $this->collHuntsPartial = $v;
    }

    /**
     * Initializes the collHunts collection.
     *
     * By default this just sets the collHunts collection to an empty array (like clearcollHunts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initHunts($overrideExisting = true)
    {
        if (null !== $this->collHunts && !$overrideExisting) {
            return;
        }

        $collectionClassName = HuntTableMap::getTableMap()->getCollectionClassName();

        $this->collHunts = new $collectionClassName;
        $this->collHunts->setModel('\Nutty\Models\Hunt');
    }

    /**
     * Gets an array of ChildHunt objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildStaff is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildHunt[] List of ChildHunt objects
     * @throws PropelException
     */
    public function getHunts(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collHuntsPartial && !$this->isNew();
        if (null === $this->collHunts || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collHunts) {
                // return empty collection
                $this->initHunts();
            } else {
                $collHunts = ChildHuntQuery::create(null, $criteria)
                    ->filterByStaff($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collHuntsPartial && count($collHunts)) {
                        $this->initHunts(false);

                        foreach ($collHunts as $obj) {
                            if (false == $this->collHunts->contains($obj)) {
                                $this->collHunts->append($obj);
                            }
                        }

                        $this->collHuntsPartial = true;
                    }

                    return $collHunts;
                }

                if ($partial && $this->collHunts) {
                    foreach ($this->collHunts as $obj) {
                        if ($obj->isNew()) {
                            $collHunts[] = $obj;
                        }
                    }
                }

                $this->collHunts = $collHunts;
                $this->collHuntsPartial = false;
            }
        }

        return $this->collHunts;
    }

    /**
     * Sets a collection of ChildHunt objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $hunts A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildStaff The current object (for fluent API support)
     */
    public function setHunts(Collection $hunts, ConnectionInterface $con = null)
    {
        /** @var ChildHunt[] $huntsToDelete */
        $huntsToDelete = $this->getHunts(new Criteria(), $con)->diff($hunts);


        $this->huntsScheduledForDeletion = $huntsToDelete;

        foreach ($huntsToDelete as $huntRemoved) {
            $huntRemoved->setStaff(null);
        }

        $this->collHunts = null;
        foreach ($hunts as $hunt) {
            $this->addHunt($hunt);
        }

        $this->collHunts = $hunts;
        $this->collHuntsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Hunt objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related Hunt objects.
     * @throws PropelException
     */
    public function countHunts(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collHuntsPartial && !$this->isNew();
        if (null === $this->collHunts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collHunts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getHunts());
            }

            $query = ChildHuntQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByStaff($this)
                ->count($con);
        }

        return count($this->collHunts);
    }

    /**
     * Method called to associate a ChildHunt object to this object
     * through the ChildHunt foreign key attribute.
     *
     * @param  ChildHunt $l ChildHunt
     * @return $this|\Nutty\Models\Staff The current object (for fluent API support)
     */
    public function addHunt(ChildHunt $l)
    {
        if ($this->collHunts === null) {
            $this->initHunts();
            $this->collHuntsPartial = true;
        }

        if (!$this->collHunts->contains($l)) {
            $this->doAddHunt($l);

            if ($this->huntsScheduledForDeletion and $this->huntsScheduledForDeletion->contains($l)) {
                $this->huntsScheduledForDeletion->remove($this->huntsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildHunt $hunt The ChildHunt object to add.
     */
    protected function doAddHunt(ChildHunt $hunt)
    {
        $this->collHunts[]= $hunt;
        $hunt->setStaff($this);
    }

    /**
     * @param  ChildHunt $hunt The ChildHunt object to remove.
     * @return $this|ChildStaff The current object (for fluent API support)
     */
    public function removeHunt(ChildHunt $hunt)
    {
        if ($this->getHunts()->contains($hunt)) {
            $pos = $this->collHunts->search($hunt);
            $this->collHunts->remove($pos);
            if (null === $this->huntsScheduledForDeletion) {
                $this->huntsScheduledForDeletion = clone $this->collHunts;
                $this->huntsScheduledForDeletion->clear();
            }
            $this->huntsScheduledForDeletion[]= clone $hunt;
            $hunt->setStaff(null);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        $this->staff_id = null;
        $this->email = null;
        $this->password = null;
        $this->token = null;
        $this->salt = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collLocationTemplates) {
                foreach ($this->collLocationTemplates as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collHunts) {
                foreach ($this->collHunts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collLocationTemplates = null;
        $this->collHunts = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(StaffTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
