<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\QuizQuestion as ChildQuizQuestion;
use Nutty\Models\QuizQuestionQuery as ChildQuizQuestionQuery;
use Nutty\Models\Map\QuizQuestionTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_quiz_question' table.
 *
 *
 *
 * @method     ChildQuizQuestionQuery orderByQuestionID($order = Criteria::ASC) Order by the question_id column
 * @method     ChildQuizQuestionQuery orderByHuntID($order = Criteria::ASC) Order by the hunt_id column
 * @method     ChildQuizQuestionQuery orderByQuestion($order = Criteria::ASC) Order by the question column
 * @method     ChildQuizQuestionQuery orderByRightANS($order = Criteria::ASC) Order by the right_ans column
 *
 * @method     ChildQuizQuestionQuery groupByQuestionID() Group by the question_id column
 * @method     ChildQuizQuestionQuery groupByHuntID() Group by the hunt_id column
 * @method     ChildQuizQuestionQuery groupByQuestion() Group by the question column
 * @method     ChildQuizQuestionQuery groupByRightANS() Group by the right_ans column
 *
 * @method     ChildQuizQuestionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildQuizQuestionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildQuizQuestionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildQuizQuestionQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildQuizQuestionQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildQuizQuestionQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildQuizQuestionQuery leftJoinHunt($relationAlias = null) Adds a LEFT JOIN clause to the query using the Hunt relation
 * @method     ChildQuizQuestionQuery rightJoinHunt($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Hunt relation
 * @method     ChildQuizQuestionQuery innerJoinHunt($relationAlias = null) Adds a INNER JOIN clause to the query using the Hunt relation
 *
 * @method     ChildQuizQuestionQuery joinWithHunt($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Hunt relation
 *
 * @method     ChildQuizQuestionQuery leftJoinWithHunt() Adds a LEFT JOIN clause and with to the query using the Hunt relation
 * @method     ChildQuizQuestionQuery rightJoinWithHunt() Adds a RIGHT JOIN clause and with to the query using the Hunt relation
 * @method     ChildQuizQuestionQuery innerJoinWithHunt() Adds a INNER JOIN clause and with to the query using the Hunt relation
 *
 * @method     ChildQuizQuestionQuery leftJoinQuizOption($relationAlias = null) Adds a LEFT JOIN clause to the query using the QuizOption relation
 * @method     ChildQuizQuestionQuery rightJoinQuizOption($relationAlias = null) Adds a RIGHT JOIN clause to the query using the QuizOption relation
 * @method     ChildQuizQuestionQuery innerJoinQuizOption($relationAlias = null) Adds a INNER JOIN clause to the query using the QuizOption relation
 *
 * @method     ChildQuizQuestionQuery joinWithQuizOption($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the QuizOption relation
 *
 * @method     ChildQuizQuestionQuery leftJoinWithQuizOption() Adds a LEFT JOIN clause and with to the query using the QuizOption relation
 * @method     ChildQuizQuestionQuery rightJoinWithQuizOption() Adds a RIGHT JOIN clause and with to the query using the QuizOption relation
 * @method     ChildQuizQuestionQuery innerJoinWithQuizOption() Adds a INNER JOIN clause and with to the query using the QuizOption relation
 *
 * @method     \Nutty\Models\HuntQuery|\Nutty\Models\QuizOptionQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildQuizQuestion findOne(ConnectionInterface $con = null) Return the first ChildQuizQuestion matching the query
 * @method     ChildQuizQuestion findOneOrCreate(ConnectionInterface $con = null) Return the first ChildQuizQuestion matching the query, or a new ChildQuizQuestion object populated from the query conditions when no match is found
 *
 * @method     ChildQuizQuestion findOneByQuestionID(int $question_id) Return the first ChildQuizQuestion filtered by the question_id column
 * @method     ChildQuizQuestion findOneByHuntID(int $hunt_id) Return the first ChildQuizQuestion filtered by the hunt_id column
 * @method     ChildQuizQuestion findOneByQuestion(string $question) Return the first ChildQuizQuestion filtered by the question column
 * @method     ChildQuizQuestion findOneByRightANS(int $right_ans) Return the first ChildQuizQuestion filtered by the right_ans column *

 * @method     ChildQuizQuestion requirePk($key, ConnectionInterface $con = null) Return the ChildQuizQuestion by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizQuestion requireOne(ConnectionInterface $con = null) Return the first ChildQuizQuestion matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildQuizQuestion requireOneByQuestionID(int $question_id) Return the first ChildQuizQuestion filtered by the question_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizQuestion requireOneByHuntID(int $hunt_id) Return the first ChildQuizQuestion filtered by the hunt_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizQuestion requireOneByQuestion(string $question) Return the first ChildQuizQuestion filtered by the question column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizQuestion requireOneByRightANS(int $right_ans) Return the first ChildQuizQuestion filtered by the right_ans column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildQuizQuestion[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildQuizQuestion objects based on current ModelCriteria
 * @method     ChildQuizQuestion[]|ObjectCollection findByQuestionID(int $question_id) Return ChildQuizQuestion objects filtered by the question_id column
 * @method     ChildQuizQuestion[]|ObjectCollection findByHuntID(int $hunt_id) Return ChildQuizQuestion objects filtered by the hunt_id column
 * @method     ChildQuizQuestion[]|ObjectCollection findByQuestion(string $question) Return ChildQuizQuestion objects filtered by the question column
 * @method     ChildQuizQuestion[]|ObjectCollection findByRightANS(int $right_ans) Return ChildQuizQuestion objects filtered by the right_ans column
 * @method     ChildQuizQuestion[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class QuizQuestionQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\QuizQuestionQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\QuizQuestion', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildQuizQuestionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildQuizQuestionQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildQuizQuestionQuery) {
            return $criteria;
        }
        $query = new ChildQuizQuestionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildQuizQuestion|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(QuizQuestionTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = QuizQuestionTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildQuizQuestion A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT question_id, hunt_id, question, right_ans FROM nt_quiz_question WHERE question_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildQuizQuestion $obj */
            $obj = new ChildQuizQuestion();
            $obj->hydrate($row);
            QuizQuestionTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildQuizQuestion|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the question_id column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestionID(1234); // WHERE question_id = 1234
     * $query->filterByQuestionID(array(12, 34)); // WHERE question_id IN (12, 34)
     * $query->filterByQuestionID(array('min' => 12)); // WHERE question_id > 12
     * </code>
     *
     * @param     mixed $questionID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByQuestionID($questionID = null, $comparison = null)
    {
        if (is_array($questionID)) {
            $useMinMax = false;
            if (isset($questionID['min'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $questionID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($questionID['max'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $questionID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $questionID, $comparison);
    }

    /**
     * Filter the query on the hunt_id column
     *
     * Example usage:
     * <code>
     * $query->filterByHuntID(1234); // WHERE hunt_id = 1234
     * $query->filterByHuntID(array(12, 34)); // WHERE hunt_id IN (12, 34)
     * $query->filterByHuntID(array('min' => 12)); // WHERE hunt_id > 12
     * </code>
     *
     * @see       filterByHunt()
     *
     * @param     mixed $huntID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByHuntID($huntID = null, $comparison = null)
    {
        if (is_array($huntID)) {
            $useMinMax = false;
            if (isset($huntID['min'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_HUNT_ID, $huntID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($huntID['max'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_HUNT_ID, $huntID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizQuestionTableMap::COL_HUNT_ID, $huntID, $comparison);
    }

    /**
     * Filter the query on the question column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestion('fooValue');   // WHERE question = 'fooValue'
     * $query->filterByQuestion('%fooValue%', Criteria::LIKE); // WHERE question LIKE '%fooValue%'
     * </code>
     *
     * @param     string $question The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByQuestion($question = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($question)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION, $question, $comparison);
    }

    /**
     * Filter the query on the right_ans column
     *
     * Example usage:
     * <code>
     * $query->filterByRightANS(1234); // WHERE right_ans = 1234
     * $query->filterByRightANS(array(12, 34)); // WHERE right_ans IN (12, 34)
     * $query->filterByRightANS(array('min' => 12)); // WHERE right_ans > 12
     * </code>
     *
     * @param     mixed $rightANS The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByRightANS($rightANS = null, $comparison = null)
    {
        if (is_array($rightANS)) {
            $useMinMax = false;
            if (isset($rightANS['min'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_RIGHT_ANS, $rightANS['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($rightANS['max'])) {
                $this->addUsingAlias(QuizQuestionTableMap::COL_RIGHT_ANS, $rightANS['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizQuestionTableMap::COL_RIGHT_ANS, $rightANS, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\Hunt object
     *
     * @param \Nutty\Models\Hunt|ObjectCollection $hunt The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByHunt($hunt, $comparison = null)
    {
        if ($hunt instanceof \Nutty\Models\Hunt) {
            return $this
                ->addUsingAlias(QuizQuestionTableMap::COL_HUNT_ID, $hunt->getHuntID(), $comparison);
        } elseif ($hunt instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(QuizQuestionTableMap::COL_HUNT_ID, $hunt->toKeyValue('PrimaryKey', 'HuntID'), $comparison);
        } else {
            throw new PropelException('filterByHunt() only accepts arguments of type \Nutty\Models\Hunt or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Hunt relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function joinHunt($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Hunt');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Hunt');
        }

        return $this;
    }

    /**
     * Use the Hunt relation Hunt object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\HuntQuery A secondary query class using the current class as primary query
     */
    public function useHuntQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinHunt($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Hunt', '\Nutty\Models\HuntQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\QuizOption object
     *
     * @param \Nutty\Models\QuizOption|ObjectCollection $quizOption the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function filterByQuizOption($quizOption, $comparison = null)
    {
        if ($quizOption instanceof \Nutty\Models\QuizOption) {
            return $this
                ->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $quizOption->getQuestionID(), $comparison);
        } elseif ($quizOption instanceof ObjectCollection) {
            return $this
                ->useQuizOptionQuery()
                ->filterByPrimaryKeys($quizOption->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByQuizOption() only accepts arguments of type \Nutty\Models\QuizOption or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the QuizOption relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function joinQuizOption($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('QuizOption');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'QuizOption');
        }

        return $this;
    }

    /**
     * Use the QuizOption relation QuizOption object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\QuizOptionQuery A secondary query class using the current class as primary query
     */
    public function useQuizOptionQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinQuizOption($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'QuizOption', '\Nutty\Models\QuizOptionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildQuizQuestion $quizQuestion Object to remove from the list of results
     *
     * @return $this|ChildQuizQuestionQuery The current query, for fluid interface
     */
    public function prune($quizQuestion = null)
    {
        if ($quizQuestion) {
            $this->addUsingAlias(QuizQuestionTableMap::COL_QUESTION_ID, $quizQuestion->getQuestionID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_quiz_question table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizQuestionTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            QuizQuestionTableMap::clearInstancePool();
            QuizQuestionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizQuestionTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(QuizQuestionTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            QuizQuestionTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            QuizQuestionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // QuizQuestionQuery
