<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\QuizOption as ChildQuizOption;
use Nutty\Models\QuizOptionQuery as ChildQuizOptionQuery;
use Nutty\Models\Map\QuizOptionTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_quiz_option' table.
 *
 *
 *
 * @method     ChildQuizOptionQuery orderByQuestionID($order = Criteria::ASC) Order by the question_id column
 * @method     ChildQuizOptionQuery orderByQuizOrder($order = Criteria::ASC) Order by the quiz_order column
 * @method     ChildQuizOptionQuery orderByQuizOption($order = Criteria::ASC) Order by the quiz_option column
 *
 * @method     ChildQuizOptionQuery groupByQuestionID() Group by the question_id column
 * @method     ChildQuizOptionQuery groupByQuizOrder() Group by the quiz_order column
 * @method     ChildQuizOptionQuery groupByQuizOption() Group by the quiz_option column
 *
 * @method     ChildQuizOptionQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildQuizOptionQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildQuizOptionQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildQuizOptionQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildQuizOptionQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildQuizOptionQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildQuizOptionQuery leftJoinQuizQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the QuizQuestion relation
 * @method     ChildQuizOptionQuery rightJoinQuizQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the QuizQuestion relation
 * @method     ChildQuizOptionQuery innerJoinQuizQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the QuizQuestion relation
 *
 * @method     ChildQuizOptionQuery joinWithQuizQuestion($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the QuizQuestion relation
 *
 * @method     ChildQuizOptionQuery leftJoinWithQuizQuestion() Adds a LEFT JOIN clause and with to the query using the QuizQuestion relation
 * @method     ChildQuizOptionQuery rightJoinWithQuizQuestion() Adds a RIGHT JOIN clause and with to the query using the QuizQuestion relation
 * @method     ChildQuizOptionQuery innerJoinWithQuizQuestion() Adds a INNER JOIN clause and with to the query using the QuizQuestion relation
 *
 * @method     \Nutty\Models\QuizQuestionQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildQuizOption findOne(ConnectionInterface $con = null) Return the first ChildQuizOption matching the query
 * @method     ChildQuizOption findOneOrCreate(ConnectionInterface $con = null) Return the first ChildQuizOption matching the query, or a new ChildQuizOption object populated from the query conditions when no match is found
 *
 * @method     ChildQuizOption findOneByQuestionID(int $question_id) Return the first ChildQuizOption filtered by the question_id column
 * @method     ChildQuizOption findOneByQuizOrder(int $quiz_order) Return the first ChildQuizOption filtered by the quiz_order column
 * @method     ChildQuizOption findOneByQuizOption(string $quiz_option) Return the first ChildQuizOption filtered by the quiz_option column *

 * @method     ChildQuizOption requirePk($key, ConnectionInterface $con = null) Return the ChildQuizOption by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizOption requireOne(ConnectionInterface $con = null) Return the first ChildQuizOption matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildQuizOption requireOneByQuestionID(int $question_id) Return the first ChildQuizOption filtered by the question_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizOption requireOneByQuizOrder(int $quiz_order) Return the first ChildQuizOption filtered by the quiz_order column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildQuizOption requireOneByQuizOption(string $quiz_option) Return the first ChildQuizOption filtered by the quiz_option column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildQuizOption[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildQuizOption objects based on current ModelCriteria
 * @method     ChildQuizOption[]|ObjectCollection findByQuestionID(int $question_id) Return ChildQuizOption objects filtered by the question_id column
 * @method     ChildQuizOption[]|ObjectCollection findByQuizOrder(int $quiz_order) Return ChildQuizOption objects filtered by the quiz_order column
 * @method     ChildQuizOption[]|ObjectCollection findByQuizOption(string $quiz_option) Return ChildQuizOption objects filtered by the quiz_option column
 * @method     ChildQuizOption[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class QuizOptionQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\QuizOptionQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\QuizOption', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildQuizOptionQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildQuizOptionQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildQuizOptionQuery) {
            return $criteria;
        }
        $query = new ChildQuizOptionQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj = $c->findPk(array(12, 34), $con);
     * </code>
     *
     * @param array[$question_id, $quiz_order] $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildQuizOption|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(QuizOptionTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = QuizOptionTableMap::getInstanceFromPool(serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]))))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildQuizOption A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT question_id, quiz_order, quiz_option FROM nt_quiz_option WHERE question_id = :p0 AND quiz_order = :p1';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key[0], PDO::PARAM_INT);
            $stmt->bindValue(':p1', $key[1], PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildQuizOption $obj */
            $obj = new ChildQuizOption();
            $obj->hydrate($row);
            QuizOptionTableMap::addInstanceToPool($obj, serialize([(null === $key[0] || is_scalar($key[0]) || is_callable([$key[0], '__toString']) ? (string) $key[0] : $key[0]), (null === $key[1] || is_scalar($key[1]) || is_callable([$key[1], '__toString']) ? (string) $key[1] : $key[1])]));
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildQuizOption|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(array(12, 56), array(832, 123), array(123, 456)), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {
        $this->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $key[0], Criteria::EQUAL);
        $this->addUsingAlias(QuizOptionTableMap::COL_QUIZ_ORDER, $key[1], Criteria::EQUAL);

        return $this;
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {
        if (empty($keys)) {
            return $this->add(null, '1<>1', Criteria::CUSTOM);
        }
        foreach ($keys as $key) {
            $cton0 = $this->getNewCriterion(QuizOptionTableMap::COL_QUESTION_ID, $key[0], Criteria::EQUAL);
            $cton1 = $this->getNewCriterion(QuizOptionTableMap::COL_QUIZ_ORDER, $key[1], Criteria::EQUAL);
            $cton0->addAnd($cton1);
            $this->addOr($cton0);
        }

        return $this;
    }

    /**
     * Filter the query on the question_id column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestionID(1234); // WHERE question_id = 1234
     * $query->filterByQuestionID(array(12, 34)); // WHERE question_id IN (12, 34)
     * $query->filterByQuestionID(array('min' => 12)); // WHERE question_id > 12
     * </code>
     *
     * @see       filterByQuizQuestion()
     *
     * @param     mixed $questionID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByQuestionID($questionID = null, $comparison = null)
    {
        if (is_array($questionID)) {
            $useMinMax = false;
            if (isset($questionID['min'])) {
                $this->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $questionID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($questionID['max'])) {
                $this->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $questionID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $questionID, $comparison);
    }

    /**
     * Filter the query on the quiz_order column
     *
     * Example usage:
     * <code>
     * $query->filterByQuizOrder(1234); // WHERE quiz_order = 1234
     * $query->filterByQuizOrder(array(12, 34)); // WHERE quiz_order IN (12, 34)
     * $query->filterByQuizOrder(array('min' => 12)); // WHERE quiz_order > 12
     * </code>
     *
     * @param     mixed $quizOrder The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByQuizOrder($quizOrder = null, $comparison = null)
    {
        if (is_array($quizOrder)) {
            $useMinMax = false;
            if (isset($quizOrder['min'])) {
                $this->addUsingAlias(QuizOptionTableMap::COL_QUIZ_ORDER, $quizOrder['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($quizOrder['max'])) {
                $this->addUsingAlias(QuizOptionTableMap::COL_QUIZ_ORDER, $quizOrder['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizOptionTableMap::COL_QUIZ_ORDER, $quizOrder, $comparison);
    }

    /**
     * Filter the query on the quiz_option column
     *
     * Example usage:
     * <code>
     * $query->filterByQuizOption('fooValue');   // WHERE quiz_option = 'fooValue'
     * $query->filterByQuizOption('%fooValue%', Criteria::LIKE); // WHERE quiz_option LIKE '%fooValue%'
     * </code>
     *
     * @param     string $quizOption The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByQuizOption($quizOption = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($quizOption)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(QuizOptionTableMap::COL_QUIZ_OPTION, $quizOption, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\QuizQuestion object
     *
     * @param \Nutty\Models\QuizQuestion|ObjectCollection $quizQuestion The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildQuizOptionQuery The current query, for fluid interface
     */
    public function filterByQuizQuestion($quizQuestion, $comparison = null)
    {
        if ($quizQuestion instanceof \Nutty\Models\QuizQuestion) {
            return $this
                ->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $quizQuestion->getQuestionID(), $comparison);
        } elseif ($quizQuestion instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(QuizOptionTableMap::COL_QUESTION_ID, $quizQuestion->toKeyValue('PrimaryKey', 'QuestionID'), $comparison);
        } else {
            throw new PropelException('filterByQuizQuestion() only accepts arguments of type \Nutty\Models\QuizQuestion or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the QuizQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function joinQuizQuestion($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('QuizQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'QuizQuestion');
        }

        return $this;
    }

    /**
     * Use the QuizQuestion relation QuizQuestion object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\QuizQuestionQuery A secondary query class using the current class as primary query
     */
    public function useQuizQuestionQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinQuizQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'QuizQuestion', '\Nutty\Models\QuizQuestionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildQuizOption $quizOption Object to remove from the list of results
     *
     * @return $this|ChildQuizOptionQuery The current query, for fluid interface
     */
    public function prune($quizOption = null)
    {
        if ($quizOption) {
            $this->addCond('pruneCond0', $this->getAliasedColName(QuizOptionTableMap::COL_QUESTION_ID), $quizOption->getQuestionID(), Criteria::NOT_EQUAL);
            $this->addCond('pruneCond1', $this->getAliasedColName(QuizOptionTableMap::COL_QUIZ_ORDER), $quizOption->getQuizOrder(), Criteria::NOT_EQUAL);
            $this->combine(array('pruneCond0', 'pruneCond1'), Criteria::LOGICAL_OR);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_quiz_option table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizOptionTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            QuizOptionTableMap::clearInstancePool();
            QuizOptionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(QuizOptionTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(QuizOptionTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            QuizOptionTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            QuizOptionTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // QuizOptionQuery
