<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\LocationTemplate as ChildLocationTemplate;
use Nutty\Models\LocationTemplateQuery as ChildLocationTemplateQuery;
use Nutty\Models\Map\LocationTemplateTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_location_template' table.
 *
 *
 *
 * @method     ChildLocationTemplateQuery orderByLocationID($order = Criteria::ASC) Order by the location_id column
 * @method     ChildLocationTemplateQuery orderByCreatorID($order = Criteria::ASC) Order by the creator_id column
 * @method     ChildLocationTemplateQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildLocationTemplateQuery orderByClue($order = Criteria::ASC) Order by the clue column
 * @method     ChildLocationTemplateQuery orderByLatitude($order = Criteria::ASC) Order by the latitude column
 * @method     ChildLocationTemplateQuery orderByLongitude($order = Criteria::ASC) Order by the longitude column
 *
 * @method     ChildLocationTemplateQuery groupByLocationID() Group by the location_id column
 * @method     ChildLocationTemplateQuery groupByCreatorID() Group by the creator_id column
 * @method     ChildLocationTemplateQuery groupByName() Group by the name column
 * @method     ChildLocationTemplateQuery groupByClue() Group by the clue column
 * @method     ChildLocationTemplateQuery groupByLatitude() Group by the latitude column
 * @method     ChildLocationTemplateQuery groupByLongitude() Group by the longitude column
 *
 * @method     ChildLocationTemplateQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildLocationTemplateQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildLocationTemplateQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildLocationTemplateQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildLocationTemplateQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildLocationTemplateQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildLocationTemplateQuery leftJoinStaff($relationAlias = null) Adds a LEFT JOIN clause to the query using the Staff relation
 * @method     ChildLocationTemplateQuery rightJoinStaff($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Staff relation
 * @method     ChildLocationTemplateQuery innerJoinStaff($relationAlias = null) Adds a INNER JOIN clause to the query using the Staff relation
 *
 * @method     ChildLocationTemplateQuery joinWithStaff($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Staff relation
 *
 * @method     ChildLocationTemplateQuery leftJoinWithStaff() Adds a LEFT JOIN clause and with to the query using the Staff relation
 * @method     ChildLocationTemplateQuery rightJoinWithStaff() Adds a RIGHT JOIN clause and with to the query using the Staff relation
 * @method     ChildLocationTemplateQuery innerJoinWithStaff() Adds a INNER JOIN clause and with to the query using the Staff relation
 *
 * @method     \Nutty\Models\StaffQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildLocationTemplate findOne(ConnectionInterface $con = null) Return the first ChildLocationTemplate matching the query
 * @method     ChildLocationTemplate findOneOrCreate(ConnectionInterface $con = null) Return the first ChildLocationTemplate matching the query, or a new ChildLocationTemplate object populated from the query conditions when no match is found
 *
 * @method     ChildLocationTemplate findOneByLocationID(int $location_id) Return the first ChildLocationTemplate filtered by the location_id column
 * @method     ChildLocationTemplate findOneByCreatorID(int $creator_id) Return the first ChildLocationTemplate filtered by the creator_id column
 * @method     ChildLocationTemplate findOneByName(string $name) Return the first ChildLocationTemplate filtered by the name column
 * @method     ChildLocationTemplate findOneByClue(string $clue) Return the first ChildLocationTemplate filtered by the clue column
 * @method     ChildLocationTemplate findOneByLatitude(string $latitude) Return the first ChildLocationTemplate filtered by the latitude column
 * @method     ChildLocationTemplate findOneByLongitude(string $longitude) Return the first ChildLocationTemplate filtered by the longitude column *

 * @method     ChildLocationTemplate requirePk($key, ConnectionInterface $con = null) Return the ChildLocationTemplate by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOne(ConnectionInterface $con = null) Return the first ChildLocationTemplate matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildLocationTemplate requireOneByLocationID(int $location_id) Return the first ChildLocationTemplate filtered by the location_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOneByCreatorID(int $creator_id) Return the first ChildLocationTemplate filtered by the creator_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOneByName(string $name) Return the first ChildLocationTemplate filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOneByClue(string $clue) Return the first ChildLocationTemplate filtered by the clue column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOneByLatitude(string $latitude) Return the first ChildLocationTemplate filtered by the latitude column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildLocationTemplate requireOneByLongitude(string $longitude) Return the first ChildLocationTemplate filtered by the longitude column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildLocationTemplate[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildLocationTemplate objects based on current ModelCriteria
 * @method     ChildLocationTemplate[]|ObjectCollection findByLocationID(int $location_id) Return ChildLocationTemplate objects filtered by the location_id column
 * @method     ChildLocationTemplate[]|ObjectCollection findByCreatorID(int $creator_id) Return ChildLocationTemplate objects filtered by the creator_id column
 * @method     ChildLocationTemplate[]|ObjectCollection findByName(string $name) Return ChildLocationTemplate objects filtered by the name column
 * @method     ChildLocationTemplate[]|ObjectCollection findByClue(string $clue) Return ChildLocationTemplate objects filtered by the clue column
 * @method     ChildLocationTemplate[]|ObjectCollection findByLatitude(string $latitude) Return ChildLocationTemplate objects filtered by the latitude column
 * @method     ChildLocationTemplate[]|ObjectCollection findByLongitude(string $longitude) Return ChildLocationTemplate objects filtered by the longitude column
 * @method     ChildLocationTemplate[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class LocationTemplateQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\LocationTemplateQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\LocationTemplate', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildLocationTemplateQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildLocationTemplateQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildLocationTemplateQuery) {
            return $criteria;
        }
        $query = new ChildLocationTemplateQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildLocationTemplate|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(LocationTemplateTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = LocationTemplateTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildLocationTemplate A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT location_id, creator_id, name, clue, latitude, longitude FROM nt_location_template WHERE location_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildLocationTemplate $obj */
            $obj = new ChildLocationTemplate();
            $obj->hydrate($row);
            LocationTemplateTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildLocationTemplate|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the location_id column
     *
     * Example usage:
     * <code>
     * $query->filterByLocationID(1234); // WHERE location_id = 1234
     * $query->filterByLocationID(array(12, 34)); // WHERE location_id IN (12, 34)
     * $query->filterByLocationID(array('min' => 12)); // WHERE location_id > 12
     * </code>
     *
     * @param     mixed $locationID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByLocationID($locationID = null, $comparison = null)
    {
        if (is_array($locationID)) {
            $useMinMax = false;
            if (isset($locationID['min'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $locationID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($locationID['max'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $locationID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $locationID, $comparison);
    }

    /**
     * Filter the query on the creator_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatorID(1234); // WHERE creator_id = 1234
     * $query->filterByCreatorID(array(12, 34)); // WHERE creator_id IN (12, 34)
     * $query->filterByCreatorID(array('min' => 12)); // WHERE creator_id > 12
     * </code>
     *
     * @see       filterByStaff()
     *
     * @param     mixed $creatorID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByCreatorID($creatorID = null, $comparison = null)
    {
        if (is_array($creatorID)) {
            $useMinMax = false;
            if (isset($creatorID['min'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_CREATOR_ID, $creatorID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($creatorID['max'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_CREATOR_ID, $creatorID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_CREATOR_ID, $creatorID, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the clue column
     *
     * Example usage:
     * <code>
     * $query->filterByClue('fooValue');   // WHERE clue = 'fooValue'
     * $query->filterByClue('%fooValue%', Criteria::LIKE); // WHERE clue LIKE '%fooValue%'
     * </code>
     *
     * @param     string $clue The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByClue($clue = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($clue)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_CLUE, $clue, $comparison);
    }

    /**
     * Filter the query on the latitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLatitude(1234); // WHERE latitude = 1234
     * $query->filterByLatitude(array(12, 34)); // WHERE latitude IN (12, 34)
     * $query->filterByLatitude(array('min' => 12)); // WHERE latitude > 12
     * </code>
     *
     * @param     mixed $latitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByLatitude($latitude = null, $comparison = null)
    {
        if (is_array($latitude)) {
            $useMinMax = false;
            if (isset($latitude['min'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LATITUDE, $latitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($latitude['max'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LATITUDE, $latitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_LATITUDE, $latitude, $comparison);
    }

    /**
     * Filter the query on the longitude column
     *
     * Example usage:
     * <code>
     * $query->filterByLongitude(1234); // WHERE longitude = 1234
     * $query->filterByLongitude(array(12, 34)); // WHERE longitude IN (12, 34)
     * $query->filterByLongitude(array('min' => 12)); // WHERE longitude > 12
     * </code>
     *
     * @param     mixed $longitude The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByLongitude($longitude = null, $comparison = null)
    {
        if (is_array($longitude)) {
            $useMinMax = false;
            if (isset($longitude['min'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LONGITUDE, $longitude['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($longitude['max'])) {
                $this->addUsingAlias(LocationTemplateTableMap::COL_LONGITUDE, $longitude['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(LocationTemplateTableMap::COL_LONGITUDE, $longitude, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\Staff object
     *
     * @param \Nutty\Models\Staff|ObjectCollection $staff The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function filterByStaff($staff, $comparison = null)
    {
        if ($staff instanceof \Nutty\Models\Staff) {
            return $this
                ->addUsingAlias(LocationTemplateTableMap::COL_CREATOR_ID, $staff->getStaffID(), $comparison);
        } elseif ($staff instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(LocationTemplateTableMap::COL_CREATOR_ID, $staff->toKeyValue('PrimaryKey', 'StaffID'), $comparison);
        } else {
            throw new PropelException('filterByStaff() only accepts arguments of type \Nutty\Models\Staff or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Staff relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function joinStaff($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Staff');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Staff');
        }

        return $this;
    }

    /**
     * Use the Staff relation Staff object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\StaffQuery A secondary query class using the current class as primary query
     */
    public function useStaffQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinStaff($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Staff', '\Nutty\Models\StaffQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildLocationTemplate $locationTemplate Object to remove from the list of results
     *
     * @return $this|ChildLocationTemplateQuery The current query, for fluid interface
     */
    public function prune($locationTemplate = null)
    {
        if ($locationTemplate) {
            $this->addUsingAlias(LocationTemplateTableMap::COL_LOCATION_ID, $locationTemplate->getLocationID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_location_template table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(LocationTemplateTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            LocationTemplateTableMap::clearInstancePool();
            LocationTemplateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(LocationTemplateTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(LocationTemplateTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            LocationTemplateTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            LocationTemplateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // LocationTemplateQuery
