<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\Hunt as ChildHunt;
use Nutty\Models\HuntQuery as ChildHuntQuery;
use Nutty\Models\Map\HuntTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_hunt' table.
 *
 *
 *
 * @method     ChildHuntQuery orderByHuntID($order = Criteria::ASC) Order by the hunt_id column
 * @method     ChildHuntQuery orderByCreatorID($order = Criteria::ASC) Order by the creator_id column
 * @method     ChildHuntQuery orderByHuntName($order = Criteria::ASC) Order by the hunt_name column
 * @method     ChildHuntQuery orderByStartTIme($order = Criteria::ASC) Order by the start_time column
 * @method     ChildHuntQuery orderByDuration($order = Criteria::ASC) Order by the duration column
 * @method     ChildHuntQuery orderByDifficulty($order = Criteria::ASC) Order by the difficulty column
 *
 * @method     ChildHuntQuery groupByHuntID() Group by the hunt_id column
 * @method     ChildHuntQuery groupByCreatorID() Group by the creator_id column
 * @method     ChildHuntQuery groupByHuntName() Group by the hunt_name column
 * @method     ChildHuntQuery groupByStartTIme() Group by the start_time column
 * @method     ChildHuntQuery groupByDuration() Group by the duration column
 * @method     ChildHuntQuery groupByDifficulty() Group by the difficulty column
 *
 * @method     ChildHuntQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildHuntQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildHuntQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildHuntQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildHuntQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildHuntQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildHuntQuery leftJoinStaff($relationAlias = null) Adds a LEFT JOIN clause to the query using the Staff relation
 * @method     ChildHuntQuery rightJoinStaff($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Staff relation
 * @method     ChildHuntQuery innerJoinStaff($relationAlias = null) Adds a INNER JOIN clause to the query using the Staff relation
 *
 * @method     ChildHuntQuery joinWithStaff($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Staff relation
 *
 * @method     ChildHuntQuery leftJoinWithStaff() Adds a LEFT JOIN clause and with to the query using the Staff relation
 * @method     ChildHuntQuery rightJoinWithStaff() Adds a RIGHT JOIN clause and with to the query using the Staff relation
 * @method     ChildHuntQuery innerJoinWithStaff() Adds a INNER JOIN clause and with to the query using the Staff relation
 *
 * @method     ChildHuntQuery leftJoinLocation($relationAlias = null) Adds a LEFT JOIN clause to the query using the Location relation
 * @method     ChildHuntQuery rightJoinLocation($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Location relation
 * @method     ChildHuntQuery innerJoinLocation($relationAlias = null) Adds a INNER JOIN clause to the query using the Location relation
 *
 * @method     ChildHuntQuery joinWithLocation($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Location relation
 *
 * @method     ChildHuntQuery leftJoinWithLocation() Adds a LEFT JOIN clause and with to the query using the Location relation
 * @method     ChildHuntQuery rightJoinWithLocation() Adds a RIGHT JOIN clause and with to the query using the Location relation
 * @method     ChildHuntQuery innerJoinWithLocation() Adds a INNER JOIN clause and with to the query using the Location relation
 *
 * @method     ChildHuntQuery leftJoinTeam($relationAlias = null) Adds a LEFT JOIN clause to the query using the Team relation
 * @method     ChildHuntQuery rightJoinTeam($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Team relation
 * @method     ChildHuntQuery innerJoinTeam($relationAlias = null) Adds a INNER JOIN clause to the query using the Team relation
 *
 * @method     ChildHuntQuery joinWithTeam($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Team relation
 *
 * @method     ChildHuntQuery leftJoinWithTeam() Adds a LEFT JOIN clause and with to the query using the Team relation
 * @method     ChildHuntQuery rightJoinWithTeam() Adds a RIGHT JOIN clause and with to the query using the Team relation
 * @method     ChildHuntQuery innerJoinWithTeam() Adds a INNER JOIN clause and with to the query using the Team relation
 *
 * @method     ChildHuntQuery leftJoinQuizQuestion($relationAlias = null) Adds a LEFT JOIN clause to the query using the QuizQuestion relation
 * @method     ChildHuntQuery rightJoinQuizQuestion($relationAlias = null) Adds a RIGHT JOIN clause to the query using the QuizQuestion relation
 * @method     ChildHuntQuery innerJoinQuizQuestion($relationAlias = null) Adds a INNER JOIN clause to the query using the QuizQuestion relation
 *
 * @method     ChildHuntQuery joinWithQuizQuestion($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the QuizQuestion relation
 *
 * @method     ChildHuntQuery leftJoinWithQuizQuestion() Adds a LEFT JOIN clause and with to the query using the QuizQuestion relation
 * @method     ChildHuntQuery rightJoinWithQuizQuestion() Adds a RIGHT JOIN clause and with to the query using the QuizQuestion relation
 * @method     ChildHuntQuery innerJoinWithQuizQuestion() Adds a INNER JOIN clause and with to the query using the QuizQuestion relation
 *
 * @method     \Nutty\Models\StaffQuery|\Nutty\Models\LocationQuery|\Nutty\Models\TeamQuery|\Nutty\Models\QuizQuestionQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildHunt findOne(ConnectionInterface $con = null) Return the first ChildHunt matching the query
 * @method     ChildHunt findOneOrCreate(ConnectionInterface $con = null) Return the first ChildHunt matching the query, or a new ChildHunt object populated from the query conditions when no match is found
 *
 * @method     ChildHunt findOneByHuntID(int $hunt_id) Return the first ChildHunt filtered by the hunt_id column
 * @method     ChildHunt findOneByCreatorID(int $creator_id) Return the first ChildHunt filtered by the creator_id column
 * @method     ChildHunt findOneByHuntName(string $hunt_name) Return the first ChildHunt filtered by the hunt_name column
 * @method     ChildHunt findOneByStartTIme(int $start_time) Return the first ChildHunt filtered by the start_time column
 * @method     ChildHunt findOneByDuration(int $duration) Return the first ChildHunt filtered by the duration column
 * @method     ChildHunt findOneByDifficulty(int $difficulty) Return the first ChildHunt filtered by the difficulty column *

 * @method     ChildHunt requirePk($key, ConnectionInterface $con = null) Return the ChildHunt by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOne(ConnectionInterface $con = null) Return the first ChildHunt matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildHunt requireOneByHuntID(int $hunt_id) Return the first ChildHunt filtered by the hunt_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOneByCreatorID(int $creator_id) Return the first ChildHunt filtered by the creator_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOneByHuntName(string $hunt_name) Return the first ChildHunt filtered by the hunt_name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOneByStartTIme(int $start_time) Return the first ChildHunt filtered by the start_time column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOneByDuration(int $duration) Return the first ChildHunt filtered by the duration column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildHunt requireOneByDifficulty(int $difficulty) Return the first ChildHunt filtered by the difficulty column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildHunt[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildHunt objects based on current ModelCriteria
 * @method     ChildHunt[]|ObjectCollection findByHuntID(int $hunt_id) Return ChildHunt objects filtered by the hunt_id column
 * @method     ChildHunt[]|ObjectCollection findByCreatorID(int $creator_id) Return ChildHunt objects filtered by the creator_id column
 * @method     ChildHunt[]|ObjectCollection findByHuntName(string $hunt_name) Return ChildHunt objects filtered by the hunt_name column
 * @method     ChildHunt[]|ObjectCollection findByStartTIme(int $start_time) Return ChildHunt objects filtered by the start_time column
 * @method     ChildHunt[]|ObjectCollection findByDuration(int $duration) Return ChildHunt objects filtered by the duration column
 * @method     ChildHunt[]|ObjectCollection findByDifficulty(int $difficulty) Return ChildHunt objects filtered by the difficulty column
 * @method     ChildHunt[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class HuntQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\HuntQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\Hunt', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildHuntQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildHuntQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildHuntQuery) {
            return $criteria;
        }
        $query = new ChildHuntQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildHunt|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(HuntTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = HuntTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildHunt A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT hunt_id, creator_id, hunt_name, start_time, duration, difficulty FROM nt_hunt WHERE hunt_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildHunt $obj */
            $obj = new ChildHunt();
            $obj->hydrate($row);
            HuntTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildHunt|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the hunt_id column
     *
     * Example usage:
     * <code>
     * $query->filterByHuntID(1234); // WHERE hunt_id = 1234
     * $query->filterByHuntID(array(12, 34)); // WHERE hunt_id IN (12, 34)
     * $query->filterByHuntID(array('min' => 12)); // WHERE hunt_id > 12
     * </code>
     *
     * @param     mixed $huntID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByHuntID($huntID = null, $comparison = null)
    {
        if (is_array($huntID)) {
            $useMinMax = false;
            if (isset($huntID['min'])) {
                $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $huntID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($huntID['max'])) {
                $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $huntID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $huntID, $comparison);
    }

    /**
     * Filter the query on the creator_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCreatorID(1234); // WHERE creator_id = 1234
     * $query->filterByCreatorID(array(12, 34)); // WHERE creator_id IN (12, 34)
     * $query->filterByCreatorID(array('min' => 12)); // WHERE creator_id > 12
     * </code>
     *
     * @see       filterByStaff()
     *
     * @param     mixed $creatorID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByCreatorID($creatorID = null, $comparison = null)
    {
        if (is_array($creatorID)) {
            $useMinMax = false;
            if (isset($creatorID['min'])) {
                $this->addUsingAlias(HuntTableMap::COL_CREATOR_ID, $creatorID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($creatorID['max'])) {
                $this->addUsingAlias(HuntTableMap::COL_CREATOR_ID, $creatorID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_CREATOR_ID, $creatorID, $comparison);
    }

    /**
     * Filter the query on the hunt_name column
     *
     * Example usage:
     * <code>
     * $query->filterByHuntName('fooValue');   // WHERE hunt_name = 'fooValue'
     * $query->filterByHuntName('%fooValue%', Criteria::LIKE); // WHERE hunt_name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $huntName The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByHuntName($huntName = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($huntName)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_HUNT_NAME, $huntName, $comparison);
    }

    /**
     * Filter the query on the start_time column
     *
     * Example usage:
     * <code>
     * $query->filterByStartTIme(1234); // WHERE start_time = 1234
     * $query->filterByStartTIme(array(12, 34)); // WHERE start_time IN (12, 34)
     * $query->filterByStartTIme(array('min' => 12)); // WHERE start_time > 12
     * </code>
     *
     * @param     mixed $startTIme The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByStartTIme($startTIme = null, $comparison = null)
    {
        if (is_array($startTIme)) {
            $useMinMax = false;
            if (isset($startTIme['min'])) {
                $this->addUsingAlias(HuntTableMap::COL_START_TIME, $startTIme['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($startTIme['max'])) {
                $this->addUsingAlias(HuntTableMap::COL_START_TIME, $startTIme['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_START_TIME, $startTIme, $comparison);
    }

    /**
     * Filter the query on the duration column
     *
     * Example usage:
     * <code>
     * $query->filterByDuration(1234); // WHERE duration = 1234
     * $query->filterByDuration(array(12, 34)); // WHERE duration IN (12, 34)
     * $query->filterByDuration(array('min' => 12)); // WHERE duration > 12
     * </code>
     *
     * @param     mixed $duration The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByDuration($duration = null, $comparison = null)
    {
        if (is_array($duration)) {
            $useMinMax = false;
            if (isset($duration['min'])) {
                $this->addUsingAlias(HuntTableMap::COL_DURATION, $duration['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($duration['max'])) {
                $this->addUsingAlias(HuntTableMap::COL_DURATION, $duration['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_DURATION, $duration, $comparison);
    }

    /**
     * Filter the query on the difficulty column
     *
     * Example usage:
     * <code>
     * $query->filterByDifficulty(1234); // WHERE difficulty = 1234
     * $query->filterByDifficulty(array(12, 34)); // WHERE difficulty IN (12, 34)
     * $query->filterByDifficulty(array('min' => 12)); // WHERE difficulty > 12
     * </code>
     *
     * @param     mixed $difficulty The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function filterByDifficulty($difficulty = null, $comparison = null)
    {
        if (is_array($difficulty)) {
            $useMinMax = false;
            if (isset($difficulty['min'])) {
                $this->addUsingAlias(HuntTableMap::COL_DIFFICULTY, $difficulty['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($difficulty['max'])) {
                $this->addUsingAlias(HuntTableMap::COL_DIFFICULTY, $difficulty['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(HuntTableMap::COL_DIFFICULTY, $difficulty, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\Staff object
     *
     * @param \Nutty\Models\Staff|ObjectCollection $staff The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildHuntQuery The current query, for fluid interface
     */
    public function filterByStaff($staff, $comparison = null)
    {
        if ($staff instanceof \Nutty\Models\Staff) {
            return $this
                ->addUsingAlias(HuntTableMap::COL_CREATOR_ID, $staff->getStaffID(), $comparison);
        } elseif ($staff instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(HuntTableMap::COL_CREATOR_ID, $staff->toKeyValue('PrimaryKey', 'StaffID'), $comparison);
        } else {
            throw new PropelException('filterByStaff() only accepts arguments of type \Nutty\Models\Staff or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Staff relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function joinStaff($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Staff');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Staff');
        }

        return $this;
    }

    /**
     * Use the Staff relation Staff object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\StaffQuery A secondary query class using the current class as primary query
     */
    public function useStaffQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinStaff($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Staff', '\Nutty\Models\StaffQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\Location object
     *
     * @param \Nutty\Models\Location|ObjectCollection $location the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildHuntQuery The current query, for fluid interface
     */
    public function filterByLocation($location, $comparison = null)
    {
        if ($location instanceof \Nutty\Models\Location) {
            return $this
                ->addUsingAlias(HuntTableMap::COL_HUNT_ID, $location->getHuntID(), $comparison);
        } elseif ($location instanceof ObjectCollection) {
            return $this
                ->useLocationQuery()
                ->filterByPrimaryKeys($location->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByLocation() only accepts arguments of type \Nutty\Models\Location or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Location relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function joinLocation($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Location');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Location');
        }

        return $this;
    }

    /**
     * Use the Location relation Location object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\LocationQuery A secondary query class using the current class as primary query
     */
    public function useLocationQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinLocation($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Location', '\Nutty\Models\LocationQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\Team object
     *
     * @param \Nutty\Models\Team|ObjectCollection $team the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildHuntQuery The current query, for fluid interface
     */
    public function filterByTeam($team, $comparison = null)
    {
        if ($team instanceof \Nutty\Models\Team) {
            return $this
                ->addUsingAlias(HuntTableMap::COL_HUNT_ID, $team->getHuntID(), $comparison);
        } elseif ($team instanceof ObjectCollection) {
            return $this
                ->useTeamQuery()
                ->filterByPrimaryKeys($team->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByTeam() only accepts arguments of type \Nutty\Models\Team or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Team relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function joinTeam($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Team');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Team');
        }

        return $this;
    }

    /**
     * Use the Team relation Team object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\TeamQuery A secondary query class using the current class as primary query
     */
    public function useTeamQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinTeam($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Team', '\Nutty\Models\TeamQuery');
    }

    /**
     * Filter the query by a related \Nutty\Models\QuizQuestion object
     *
     * @param \Nutty\Models\QuizQuestion|ObjectCollection $quizQuestion the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildHuntQuery The current query, for fluid interface
     */
    public function filterByQuizQuestion($quizQuestion, $comparison = null)
    {
        if ($quizQuestion instanceof \Nutty\Models\QuizQuestion) {
            return $this
                ->addUsingAlias(HuntTableMap::COL_HUNT_ID, $quizQuestion->getHuntID(), $comparison);
        } elseif ($quizQuestion instanceof ObjectCollection) {
            return $this
                ->useQuizQuestionQuery()
                ->filterByPrimaryKeys($quizQuestion->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByQuizQuestion() only accepts arguments of type \Nutty\Models\QuizQuestion or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the QuizQuestion relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function joinQuizQuestion($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('QuizQuestion');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'QuizQuestion');
        }

        return $this;
    }

    /**
     * Use the QuizQuestion relation QuizQuestion object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\QuizQuestionQuery A secondary query class using the current class as primary query
     */
    public function useQuizQuestionQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinQuizQuestion($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'QuizQuestion', '\Nutty\Models\QuizQuestionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildHunt $hunt Object to remove from the list of results
     *
     * @return $this|ChildHuntQuery The current query, for fluid interface
     */
    public function prune($hunt = null)
    {
        if ($hunt) {
            $this->addUsingAlias(HuntTableMap::COL_HUNT_ID, $hunt->getHuntID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_hunt table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(HuntTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            HuntTableMap::clearInstancePool();
            HuntTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(HuntTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(HuntTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            HuntTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            HuntTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // HuntQuery
