<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\Hunt as ChildHunt;
use Nutty\Models\HuntQuery as ChildHuntQuery;
use Nutty\Models\Location as ChildLocation;
use Nutty\Models\LocationQuery as ChildLocationQuery;
use Nutty\Models\QuizQuestion as ChildQuizQuestion;
use Nutty\Models\QuizQuestionQuery as ChildQuizQuestionQuery;
use Nutty\Models\Staff as ChildStaff;
use Nutty\Models\StaffQuery as ChildStaffQuery;
use Nutty\Models\Team as ChildTeam;
use Nutty\Models\TeamQuery as ChildTeamQuery;
use Nutty\Models\Map\HuntTableMap;
use Nutty\Models\Map\LocationTableMap;
use Nutty\Models\Map\QuizQuestionTableMap;
use Nutty\Models\Map\TeamTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;

/**
 * Base class that represents a row from the 'nt_hunt' table.
 *
 *
 *
 * @package    propel.generator.Nutty.Models.Base
 */
abstract class Hunt implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Nutty\\Models\\Map\\HuntTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the hunt_id field.
     *
     * @var        int
     */
    protected $hunt_id;

    /**
     * The value for the creator_id field.
     *
     * @var        int
     */
    protected $creator_id;

    /**
     * The value for the hunt_name field.
     *
     * @var        string
     */
    protected $hunt_name;

    /**
     * The value for the start_time field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $start_time;

    /**
     * The value for the duration field.
     *
     * @var        int
     */
    protected $duration;

    /**
     * The value for the difficulty field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $difficulty;

    /**
     * @var        ChildStaff
     */
    protected $aStaff;

    /**
     * @var        ObjectCollection|ChildLocation[] Collection to store aggregation of ChildLocation objects.
     */
    protected $collLocations;
    protected $collLocationsPartial;

    /**
     * @var        ObjectCollection|ChildTeam[] Collection to store aggregation of ChildTeam objects.
     */
    protected $collTeams;
    protected $collTeamsPartial;

    /**
     * @var        ObjectCollection|ChildQuizQuestion[] Collection to store aggregation of ChildQuizQuestion objects.
     */
    protected $collQuizQuestions;
    protected $collQuizQuestionsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildLocation[]
     */
    protected $locationsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildTeam[]
     */
    protected $teamsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildQuizQuestion[]
     */
    protected $quizQuestionsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->start_time = 0;
        $this->difficulty = 0;
    }

    /**
     * Initializes internal state of Nutty\Models\Base\Hunt object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Hunt</code> instance.  If
     * <code>obj</code> is an instance of <code>Hunt</code>, delegates to
     * <code>equals(Hunt)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Hunt The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [hunt_id] column value.
     *
     * @return int
     */
    public function getHuntID()
    {
        return $this->hunt_id;
    }

    /**
     * Get the [creator_id] column value.
     *
     * @return int
     */
    public function getCreatorID()
    {
        return $this->creator_id;
    }

    /**
     * Get the [hunt_name] column value.
     *
     * @return string
     */
    public function getHuntName()
    {
        return $this->hunt_name;
    }

    /**
     * Get the [start_time] column value.
     *
     * @return int
     */
    public function getStartTIme()
    {
        return $this->start_time;
    }

    /**
     * Get the [duration] column value.
     *
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * Get the [difficulty] column value.
     *
     * @return int
     */
    public function getDifficulty()
    {
        return $this->difficulty;
    }

    /**
     * Set the value of [hunt_id] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setHuntID($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->hunt_id !== $v) {
            $this->hunt_id = $v;
            $this->modifiedColumns[HuntTableMap::COL_HUNT_ID] = true;
        }

        return $this;
    } // setHuntID()

    /**
     * Set the value of [creator_id] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setCreatorID($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->creator_id !== $v) {
            $this->creator_id = $v;
            $this->modifiedColumns[HuntTableMap::COL_CREATOR_ID] = true;
        }

        if ($this->aStaff !== null && $this->aStaff->getStaffID() !== $v) {
            $this->aStaff = null;
        }

        return $this;
    } // setCreatorID()

    /**
     * Set the value of [hunt_name] column.
     *
     * @param string $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setHuntName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->hunt_name !== $v) {
            $this->hunt_name = $v;
            $this->modifiedColumns[HuntTableMap::COL_HUNT_NAME] = true;
        }

        return $this;
    } // setHuntName()

    /**
     * Set the value of [start_time] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setStartTIme($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->start_time !== $v) {
            $this->start_time = $v;
            $this->modifiedColumns[HuntTableMap::COL_START_TIME] = true;
        }

        return $this;
    } // setStartTIme()

    /**
     * Set the value of [duration] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setDuration($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->duration !== $v) {
            $this->duration = $v;
            $this->modifiedColumns[HuntTableMap::COL_DURATION] = true;
        }

        return $this;
    } // setDuration()

    /**
     * Set the value of [difficulty] column.
     *
     * @param int $v new value
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function setDifficulty($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->difficulty !== $v) {
            $this->difficulty = $v;
            $this->modifiedColumns[HuntTableMap::COL_DIFFICULTY] = true;
        }

        return $this;
    } // setDifficulty()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->start_time !== 0) {
                return false;
            }

            if ($this->difficulty !== 0) {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : HuntTableMap::translateFieldName('HuntID', TableMap::TYPE_PHPNAME, $indexType)];
            $this->hunt_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : HuntTableMap::translateFieldName('CreatorID', TableMap::TYPE_PHPNAME, $indexType)];
            $this->creator_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : HuntTableMap::translateFieldName('HuntName', TableMap::TYPE_PHPNAME, $indexType)];
            $this->hunt_name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : HuntTableMap::translateFieldName('StartTIme', TableMap::TYPE_PHPNAME, $indexType)];
            $this->start_time = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : HuntTableMap::translateFieldName('Duration', TableMap::TYPE_PHPNAME, $indexType)];
            $this->duration = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : HuntTableMap::translateFieldName('Difficulty', TableMap::TYPE_PHPNAME, $indexType)];
            $this->difficulty = (null !== $col) ? (int) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 6; // 6 = HuntTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Nutty\\Models\\Hunt'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aStaff !== null && $this->creator_id !== $this->aStaff->getStaffID()) {
            $this->aStaff = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(HuntTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildHuntQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aStaff = null;
            $this->collLocations = null;

            $this->collTeams = null;

            $this->collQuizQuestions = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Hunt::setDeleted()
     * @see Hunt::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(HuntTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildHuntQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(HuntTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                HuntTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aStaff !== null) {
                if ($this->aStaff->isModified() || $this->aStaff->isNew()) {
                    $affectedRows += $this->aStaff->save($con);
                }
                $this->setStaff($this->aStaff);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->locationsScheduledForDeletion !== null) {
                if (!$this->locationsScheduledForDeletion->isEmpty()) {
                    \Nutty\Models\LocationQuery::create()
                        ->filterByPrimaryKeys($this->locationsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->locationsScheduledForDeletion = null;
                }
            }

            if ($this->collLocations !== null) {
                foreach ($this->collLocations as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->teamsScheduledForDeletion !== null) {
                if (!$this->teamsScheduledForDeletion->isEmpty()) {
                    \Nutty\Models\TeamQuery::create()
                        ->filterByPrimaryKeys($this->teamsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->teamsScheduledForDeletion = null;
                }
            }

            if ($this->collTeams !== null) {
                foreach ($this->collTeams as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->quizQuestionsScheduledForDeletion !== null) {
                if (!$this->quizQuestionsScheduledForDeletion->isEmpty()) {
                    \Nutty\Models\QuizQuestionQuery::create()
                        ->filterByPrimaryKeys($this->quizQuestionsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->quizQuestionsScheduledForDeletion = null;
                }
            }

            if ($this->collQuizQuestions !== null) {
                foreach ($this->collQuizQuestions as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[HuntTableMap::COL_HUNT_ID] = true;
        if (null !== $this->hunt_id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . HuntTableMap::COL_HUNT_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(HuntTableMap::COL_HUNT_ID)) {
            $modifiedColumns[':p' . $index++]  = 'hunt_id';
        }
        if ($this->isColumnModified(HuntTableMap::COL_CREATOR_ID)) {
            $modifiedColumns[':p' . $index++]  = 'creator_id';
        }
        if ($this->isColumnModified(HuntTableMap::COL_HUNT_NAME)) {
            $modifiedColumns[':p' . $index++]  = 'hunt_name';
        }
        if ($this->isColumnModified(HuntTableMap::COL_START_TIME)) {
            $modifiedColumns[':p' . $index++]  = 'start_time';
        }
        if ($this->isColumnModified(HuntTableMap::COL_DURATION)) {
            $modifiedColumns[':p' . $index++]  = 'duration';
        }
        if ($this->isColumnModified(HuntTableMap::COL_DIFFICULTY)) {
            $modifiedColumns[':p' . $index++]  = 'difficulty';
        }

        $sql = sprintf(
            'INSERT INTO nt_hunt (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case 'hunt_id':
                        $stmt->bindValue($identifier, $this->hunt_id, PDO::PARAM_INT);
                        break;
                    case 'creator_id':
                        $stmt->bindValue($identifier, $this->creator_id, PDO::PARAM_INT);
                        break;
                    case 'hunt_name':
                        $stmt->bindValue($identifier, $this->hunt_name, PDO::PARAM_STR);
                        break;
                    case 'start_time':
                        $stmt->bindValue($identifier, $this->start_time, PDO::PARAM_INT);
                        break;
                    case 'duration':
                        $stmt->bindValue($identifier, $this->duration, PDO::PARAM_INT);
                        break;
                    case 'difficulty':
                        $stmt->bindValue($identifier, $this->difficulty, PDO::PARAM_INT);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setHuntID($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = HuntTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getHuntID();
                break;
            case 1:
                return $this->getCreatorID();
                break;
            case 2:
                return $this->getHuntName();
                break;
            case 3:
                return $this->getStartTIme();
                break;
            case 4:
                return $this->getDuration();
                break;
            case 5:
                return $this->getDifficulty();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Hunt'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Hunt'][$this->hashCode()] = true;
        $keys = HuntTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getHuntID(),
            $keys[1] => $this->getCreatorID(),
            $keys[2] => $this->getHuntName(),
            $keys[3] => $this->getStartTIme(),
            $keys[4] => $this->getDuration(),
            $keys[5] => $this->getDifficulty(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aStaff) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'staff';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_staff';
                        break;
                    default:
                        $key = 'Staff';
                }

                $result[$key] = $this->aStaff->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collLocations) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'locations';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_locations';
                        break;
                    default:
                        $key = 'Locations';
                }

                $result[$key] = $this->collLocations->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collTeams) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'teams';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_teams';
                        break;
                    default:
                        $key = 'Teams';
                }

                $result[$key] = $this->collTeams->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collQuizQuestions) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'quizQuestions';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'nt_quiz_questions';
                        break;
                    default:
                        $key = 'QuizQuestions';
                }

                $result[$key] = $this->collQuizQuestions->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Nutty\Models\Hunt
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = HuntTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Nutty\Models\Hunt
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setHuntID($value);
                break;
            case 1:
                $this->setCreatorID($value);
                break;
            case 2:
                $this->setHuntName($value);
                break;
            case 3:
                $this->setStartTIme($value);
                break;
            case 4:
                $this->setDuration($value);
                break;
            case 5:
                $this->setDifficulty($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = HuntTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setHuntID($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setCreatorID($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setHuntName($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setStartTIme($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setDuration($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setDifficulty($arr[$keys[5]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Nutty\Models\Hunt The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(HuntTableMap::DATABASE_NAME);

        if ($this->isColumnModified(HuntTableMap::COL_HUNT_ID)) {
            $criteria->add(HuntTableMap::COL_HUNT_ID, $this->hunt_id);
        }
        if ($this->isColumnModified(HuntTableMap::COL_CREATOR_ID)) {
            $criteria->add(HuntTableMap::COL_CREATOR_ID, $this->creator_id);
        }
        if ($this->isColumnModified(HuntTableMap::COL_HUNT_NAME)) {
            $criteria->add(HuntTableMap::COL_HUNT_NAME, $this->hunt_name);
        }
        if ($this->isColumnModified(HuntTableMap::COL_START_TIME)) {
            $criteria->add(HuntTableMap::COL_START_TIME, $this->start_time);
        }
        if ($this->isColumnModified(HuntTableMap::COL_DURATION)) {
            $criteria->add(HuntTableMap::COL_DURATION, $this->duration);
        }
        if ($this->isColumnModified(HuntTableMap::COL_DIFFICULTY)) {
            $criteria->add(HuntTableMap::COL_DIFFICULTY, $this->difficulty);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildHuntQuery::create();
        $criteria->add(HuntTableMap::COL_HUNT_ID, $this->hunt_id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getHuntID();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getHuntID();
    }

    /**
     * Generic method to set the primary key (hunt_id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setHuntID($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getHuntID();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Nutty\Models\Hunt (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setCreatorID($this->getCreatorID());
        $copyObj->setHuntName($this->getHuntName());
        $copyObj->setStartTIme($this->getStartTIme());
        $copyObj->setDuration($this->getDuration());
        $copyObj->setDifficulty($this->getDifficulty());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getLocations() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addLocation($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getTeams() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addTeam($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getQuizQuestions() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addQuizQuestion($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setHuntID(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Nutty\Models\Hunt Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a ChildStaff object.
     *
     * @param  ChildStaff $v
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     * @throws PropelException
     */
    public function setStaff(ChildStaff $v = null)
    {
        if ($v === null) {
            $this->setCreatorID(NULL);
        } else {
            $this->setCreatorID($v->getStaffID());
        }

        $this->aStaff = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ChildStaff object, it will not be re-added.
        if ($v !== null) {
            $v->addHunt($this);
        }


        return $this;
    }


    /**
     * Get the associated ChildStaff object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return ChildStaff The associated ChildStaff object.
     * @throws PropelException
     */
    public function getStaff(ConnectionInterface $con = null)
    {
        if ($this->aStaff === null && ($this->creator_id !== null)) {
            $this->aStaff = ChildStaffQuery::create()->findPk($this->creator_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aStaff->addHunts($this);
             */
        }

        return $this->aStaff;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Location' == $relationName) {
            return $this->initLocations();
        }
        if ('Team' == $relationName) {
            return $this->initTeams();
        }
        if ('QuizQuestion' == $relationName) {
            return $this->initQuizQuestions();
        }
    }

    /**
     * Clears out the collLocations collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addLocations()
     */
    public function clearLocations()
    {
        $this->collLocations = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collLocations collection loaded partially.
     */
    public function resetPartialLocations($v = true)
    {
        $this->collLocationsPartial = $v;
    }

    /**
     * Initializes the collLocations collection.
     *
     * By default this just sets the collLocations collection to an empty array (like clearcollLocations());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initLocations($overrideExisting = true)
    {
        if (null !== $this->collLocations && !$overrideExisting) {
            return;
        }

        $collectionClassName = LocationTableMap::getTableMap()->getCollectionClassName();

        $this->collLocations = new $collectionClassName;
        $this->collLocations->setModel('\Nutty\Models\Location');
    }

    /**
     * Gets an array of ChildLocation objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildHunt is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildLocation[] List of ChildLocation objects
     * @throws PropelException
     */
    public function getLocations(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collLocationsPartial && !$this->isNew();
        if (null === $this->collLocations || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collLocations) {
                // return empty collection
                $this->initLocations();
            } else {
                $collLocations = ChildLocationQuery::create(null, $criteria)
                    ->filterByHunt($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collLocationsPartial && count($collLocations)) {
                        $this->initLocations(false);

                        foreach ($collLocations as $obj) {
                            if (false == $this->collLocations->contains($obj)) {
                                $this->collLocations->append($obj);
                            }
                        }

                        $this->collLocationsPartial = true;
                    }

                    return $collLocations;
                }

                if ($partial && $this->collLocations) {
                    foreach ($this->collLocations as $obj) {
                        if ($obj->isNew()) {
                            $collLocations[] = $obj;
                        }
                    }
                }

                $this->collLocations = $collLocations;
                $this->collLocationsPartial = false;
            }
        }

        return $this->collLocations;
    }

    /**
     * Sets a collection of ChildLocation objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $locations A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function setLocations(Collection $locations, ConnectionInterface $con = null)
    {
        /** @var ChildLocation[] $locationsToDelete */
        $locationsToDelete = $this->getLocations(new Criteria(), $con)->diff($locations);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->locationsScheduledForDeletion = clone $locationsToDelete;

        foreach ($locationsToDelete as $locationRemoved) {
            $locationRemoved->setHunt(null);
        }

        $this->collLocations = null;
        foreach ($locations as $location) {
            $this->addLocation($location);
        }

        $this->collLocations = $locations;
        $this->collLocationsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Location objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related Location objects.
     * @throws PropelException
     */
    public function countLocations(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collLocationsPartial && !$this->isNew();
        if (null === $this->collLocations || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collLocations) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getLocations());
            }

            $query = ChildLocationQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByHunt($this)
                ->count($con);
        }

        return count($this->collLocations);
    }

    /**
     * Method called to associate a ChildLocation object to this object
     * through the ChildLocation foreign key attribute.
     *
     * @param  ChildLocation $l ChildLocation
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function addLocation(ChildLocation $l)
    {
        if ($this->collLocations === null) {
            $this->initLocations();
            $this->collLocationsPartial = true;
        }

        if (!$this->collLocations->contains($l)) {
            $this->doAddLocation($l);

            if ($this->locationsScheduledForDeletion and $this->locationsScheduledForDeletion->contains($l)) {
                $this->locationsScheduledForDeletion->remove($this->locationsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildLocation $location The ChildLocation object to add.
     */
    protected function doAddLocation(ChildLocation $location)
    {
        $this->collLocations[]= $location;
        $location->setHunt($this);
    }

    /**
     * @param  ChildLocation $location The ChildLocation object to remove.
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function removeLocation(ChildLocation $location)
    {
        if ($this->getLocations()->contains($location)) {
            $pos = $this->collLocations->search($location);
            $this->collLocations->remove($pos);
            if (null === $this->locationsScheduledForDeletion) {
                $this->locationsScheduledForDeletion = clone $this->collLocations;
                $this->locationsScheduledForDeletion->clear();
            }
            $this->locationsScheduledForDeletion[]= clone $location;
            $location->setHunt(null);
        }

        return $this;
    }

    /**
     * Clears out the collTeams collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addTeams()
     */
    public function clearTeams()
    {
        $this->collTeams = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collTeams collection loaded partially.
     */
    public function resetPartialTeams($v = true)
    {
        $this->collTeamsPartial = $v;
    }

    /**
     * Initializes the collTeams collection.
     *
     * By default this just sets the collTeams collection to an empty array (like clearcollTeams());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initTeams($overrideExisting = true)
    {
        if (null !== $this->collTeams && !$overrideExisting) {
            return;
        }

        $collectionClassName = TeamTableMap::getTableMap()->getCollectionClassName();

        $this->collTeams = new $collectionClassName;
        $this->collTeams->setModel('\Nutty\Models\Team');
    }

    /**
     * Gets an array of ChildTeam objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildHunt is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildTeam[] List of ChildTeam objects
     * @throws PropelException
     */
    public function getTeams(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collTeamsPartial && !$this->isNew();
        if (null === $this->collTeams || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collTeams) {
                // return empty collection
                $this->initTeams();
            } else {
                $collTeams = ChildTeamQuery::create(null, $criteria)
                    ->filterByHunt($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collTeamsPartial && count($collTeams)) {
                        $this->initTeams(false);

                        foreach ($collTeams as $obj) {
                            if (false == $this->collTeams->contains($obj)) {
                                $this->collTeams->append($obj);
                            }
                        }

                        $this->collTeamsPartial = true;
                    }

                    return $collTeams;
                }

                if ($partial && $this->collTeams) {
                    foreach ($this->collTeams as $obj) {
                        if ($obj->isNew()) {
                            $collTeams[] = $obj;
                        }
                    }
                }

                $this->collTeams = $collTeams;
                $this->collTeamsPartial = false;
            }
        }

        return $this->collTeams;
    }

    /**
     * Sets a collection of ChildTeam objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $teams A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function setTeams(Collection $teams, ConnectionInterface $con = null)
    {
        /** @var ChildTeam[] $teamsToDelete */
        $teamsToDelete = $this->getTeams(new Criteria(), $con)->diff($teams);


        $this->teamsScheduledForDeletion = $teamsToDelete;

        foreach ($teamsToDelete as $teamRemoved) {
            $teamRemoved->setHunt(null);
        }

        $this->collTeams = null;
        foreach ($teams as $team) {
            $this->addTeam($team);
        }

        $this->collTeams = $teams;
        $this->collTeamsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Team objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related Team objects.
     * @throws PropelException
     */
    public function countTeams(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collTeamsPartial && !$this->isNew();
        if (null === $this->collTeams || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collTeams) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getTeams());
            }

            $query = ChildTeamQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByHunt($this)
                ->count($con);
        }

        return count($this->collTeams);
    }

    /**
     * Method called to associate a ChildTeam object to this object
     * through the ChildTeam foreign key attribute.
     *
     * @param  ChildTeam $l ChildTeam
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function addTeam(ChildTeam $l)
    {
        if ($this->collTeams === null) {
            $this->initTeams();
            $this->collTeamsPartial = true;
        }

        if (!$this->collTeams->contains($l)) {
            $this->doAddTeam($l);

            if ($this->teamsScheduledForDeletion and $this->teamsScheduledForDeletion->contains($l)) {
                $this->teamsScheduledForDeletion->remove($this->teamsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildTeam $team The ChildTeam object to add.
     */
    protected function doAddTeam(ChildTeam $team)
    {
        $this->collTeams[]= $team;
        $team->setHunt($this);
    }

    /**
     * @param  ChildTeam $team The ChildTeam object to remove.
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function removeTeam(ChildTeam $team)
    {
        if ($this->getTeams()->contains($team)) {
            $pos = $this->collTeams->search($team);
            $this->collTeams->remove($pos);
            if (null === $this->teamsScheduledForDeletion) {
                $this->teamsScheduledForDeletion = clone $this->collTeams;
                $this->teamsScheduledForDeletion->clear();
            }
            $this->teamsScheduledForDeletion[]= clone $team;
            $team->setHunt(null);
        }

        return $this;
    }

    /**
     * Clears out the collQuizQuestions collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addQuizQuestions()
     */
    public function clearQuizQuestions()
    {
        $this->collQuizQuestions = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collQuizQuestions collection loaded partially.
     */
    public function resetPartialQuizQuestions($v = true)
    {
        $this->collQuizQuestionsPartial = $v;
    }

    /**
     * Initializes the collQuizQuestions collection.
     *
     * By default this just sets the collQuizQuestions collection to an empty array (like clearcollQuizQuestions());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initQuizQuestions($overrideExisting = true)
    {
        if (null !== $this->collQuizQuestions && !$overrideExisting) {
            return;
        }

        $collectionClassName = QuizQuestionTableMap::getTableMap()->getCollectionClassName();

        $this->collQuizQuestions = new $collectionClassName;
        $this->collQuizQuestions->setModel('\Nutty\Models\QuizQuestion');
    }

    /**
     * Gets an array of ChildQuizQuestion objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildHunt is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildQuizQuestion[] List of ChildQuizQuestion objects
     * @throws PropelException
     */
    public function getQuizQuestions(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collQuizQuestionsPartial && !$this->isNew();
        if (null === $this->collQuizQuestions || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collQuizQuestions) {
                // return empty collection
                $this->initQuizQuestions();
            } else {
                $collQuizQuestions = ChildQuizQuestionQuery::create(null, $criteria)
                    ->filterByHunt($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collQuizQuestionsPartial && count($collQuizQuestions)) {
                        $this->initQuizQuestions(false);

                        foreach ($collQuizQuestions as $obj) {
                            if (false == $this->collQuizQuestions->contains($obj)) {
                                $this->collQuizQuestions->append($obj);
                            }
                        }

                        $this->collQuizQuestionsPartial = true;
                    }

                    return $collQuizQuestions;
                }

                if ($partial && $this->collQuizQuestions) {
                    foreach ($this->collQuizQuestions as $obj) {
                        if ($obj->isNew()) {
                            $collQuizQuestions[] = $obj;
                        }
                    }
                }

                $this->collQuizQuestions = $collQuizQuestions;
                $this->collQuizQuestionsPartial = false;
            }
        }

        return $this->collQuizQuestions;
    }

    /**
     * Sets a collection of ChildQuizQuestion objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $quizQuestions A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function setQuizQuestions(Collection $quizQuestions, ConnectionInterface $con = null)
    {
        /** @var ChildQuizQuestion[] $quizQuestionsToDelete */
        $quizQuestionsToDelete = $this->getQuizQuestions(new Criteria(), $con)->diff($quizQuestions);


        $this->quizQuestionsScheduledForDeletion = $quizQuestionsToDelete;

        foreach ($quizQuestionsToDelete as $quizQuestionRemoved) {
            $quizQuestionRemoved->setHunt(null);
        }

        $this->collQuizQuestions = null;
        foreach ($quizQuestions as $quizQuestion) {
            $this->addQuizQuestion($quizQuestion);
        }

        $this->collQuizQuestions = $quizQuestions;
        $this->collQuizQuestionsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related QuizQuestion objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related QuizQuestion objects.
     * @throws PropelException
     */
    public function countQuizQuestions(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collQuizQuestionsPartial && !$this->isNew();
        if (null === $this->collQuizQuestions || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collQuizQuestions) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getQuizQuestions());
            }

            $query = ChildQuizQuestionQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByHunt($this)
                ->count($con);
        }

        return count($this->collQuizQuestions);
    }

    /**
     * Method called to associate a ChildQuizQuestion object to this object
     * through the ChildQuizQuestion foreign key attribute.
     *
     * @param  ChildQuizQuestion $l ChildQuizQuestion
     * @return $this|\Nutty\Models\Hunt The current object (for fluent API support)
     */
    public function addQuizQuestion(ChildQuizQuestion $l)
    {
        if ($this->collQuizQuestions === null) {
            $this->initQuizQuestions();
            $this->collQuizQuestionsPartial = true;
        }

        if (!$this->collQuizQuestions->contains($l)) {
            $this->doAddQuizQuestion($l);

            if ($this->quizQuestionsScheduledForDeletion and $this->quizQuestionsScheduledForDeletion->contains($l)) {
                $this->quizQuestionsScheduledForDeletion->remove($this->quizQuestionsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildQuizQuestion $quizQuestion The ChildQuizQuestion object to add.
     */
    protected function doAddQuizQuestion(ChildQuizQuestion $quizQuestion)
    {
        $this->collQuizQuestions[]= $quizQuestion;
        $quizQuestion->setHunt($this);
    }

    /**
     * @param  ChildQuizQuestion $quizQuestion The ChildQuizQuestion object to remove.
     * @return $this|ChildHunt The current object (for fluent API support)
     */
    public function removeQuizQuestion(ChildQuizQuestion $quizQuestion)
    {
        if ($this->getQuizQuestions()->contains($quizQuestion)) {
            $pos = $this->collQuizQuestions->search($quizQuestion);
            $this->collQuizQuestions->remove($pos);
            if (null === $this->quizQuestionsScheduledForDeletion) {
                $this->quizQuestionsScheduledForDeletion = clone $this->collQuizQuestions;
                $this->quizQuestionsScheduledForDeletion->clear();
            }
            $this->quizQuestionsScheduledForDeletion[]= clone $quizQuestion;
            $quizQuestion->setHunt(null);
        }

        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aStaff) {
            $this->aStaff->removeHunt($this);
        }
        $this->hunt_id = null;
        $this->creator_id = null;
        $this->hunt_name = null;
        $this->start_time = null;
        $this->duration = null;
        $this->difficulty = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collLocations) {
                foreach ($this->collLocations as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collTeams) {
                foreach ($this->collTeams as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collQuizQuestions) {
                foreach ($this->collQuizQuestions as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collLocations = null;
        $this->collTeams = null;
        $this->collQuizQuestions = null;
        $this->aStaff = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(HuntTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
