<?php

namespace Nutty\Models\Base;

use \Exception;
use \PDO;
use Nutty\Models\GameRecord as ChildGameRecord;
use Nutty\Models\GameRecordQuery as ChildGameRecordQuery;
use Nutty\Models\Map\GameRecordTableMap;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;

/**
 * Base class that represents a query for the 'nt_game_record' table.
 *
 *
 *
 * @method     ChildGameRecordQuery orderByTeamID($order = Criteria::ASC) Order by the team_id column
 * @method     ChildGameRecordQuery orderByTimeFirstGetLoc($order = Criteria::ASC) Order by the time_first_get_loc column
 * @method     ChildGameRecordQuery orderByCluesFound($order = Criteria::ASC) Order by the clues_found column
 * @method     ChildGameRecordQuery orderByRevealTime($order = Criteria::ASC) Order by the reveal_time column
 * @method     ChildGameRecordQuery orderByRank($order = Criteria::ASC) Order by the rank column
 * @method     ChildGameRecordQuery orderByQuestion($order = Criteria::ASC) Order by the question column
 *
 * @method     ChildGameRecordQuery groupByTeamID() Group by the team_id column
 * @method     ChildGameRecordQuery groupByTimeFirstGetLoc() Group by the time_first_get_loc column
 * @method     ChildGameRecordQuery groupByCluesFound() Group by the clues_found column
 * @method     ChildGameRecordQuery groupByRevealTime() Group by the reveal_time column
 * @method     ChildGameRecordQuery groupByRank() Group by the rank column
 * @method     ChildGameRecordQuery groupByQuestion() Group by the question column
 *
 * @method     ChildGameRecordQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildGameRecordQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildGameRecordQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildGameRecordQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildGameRecordQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildGameRecordQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildGameRecordQuery leftJoinTeam($relationAlias = null) Adds a LEFT JOIN clause to the query using the Team relation
 * @method     ChildGameRecordQuery rightJoinTeam($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Team relation
 * @method     ChildGameRecordQuery innerJoinTeam($relationAlias = null) Adds a INNER JOIN clause to the query using the Team relation
 *
 * @method     ChildGameRecordQuery joinWithTeam($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Team relation
 *
 * @method     ChildGameRecordQuery leftJoinWithTeam() Adds a LEFT JOIN clause and with to the query using the Team relation
 * @method     ChildGameRecordQuery rightJoinWithTeam() Adds a RIGHT JOIN clause and with to the query using the Team relation
 * @method     ChildGameRecordQuery innerJoinWithTeam() Adds a INNER JOIN clause and with to the query using the Team relation
 *
 * @method     \Nutty\Models\TeamQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildGameRecord findOne(ConnectionInterface $con = null) Return the first ChildGameRecord matching the query
 * @method     ChildGameRecord findOneOrCreate(ConnectionInterface $con = null) Return the first ChildGameRecord matching the query, or a new ChildGameRecord object populated from the query conditions when no match is found
 *
 * @method     ChildGameRecord findOneByTeamID(int $team_id) Return the first ChildGameRecord filtered by the team_id column
 * @method     ChildGameRecord findOneByTimeFirstGetLoc(int $time_first_get_loc) Return the first ChildGameRecord filtered by the time_first_get_loc column
 * @method     ChildGameRecord findOneByCluesFound(int $clues_found) Return the first ChildGameRecord filtered by the clues_found column
 * @method     ChildGameRecord findOneByRevealTime(int $reveal_time) Return the first ChildGameRecord filtered by the reveal_time column
 * @method     ChildGameRecord findOneByRank(int $rank) Return the first ChildGameRecord filtered by the rank column
 * @method     ChildGameRecord findOneByQuestion(int $question) Return the first ChildGameRecord filtered by the question column *

 * @method     ChildGameRecord requirePk($key, ConnectionInterface $con = null) Return the ChildGameRecord by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOne(ConnectionInterface $con = null) Return the first ChildGameRecord matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildGameRecord requireOneByTeamID(int $team_id) Return the first ChildGameRecord filtered by the team_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOneByTimeFirstGetLoc(int $time_first_get_loc) Return the first ChildGameRecord filtered by the time_first_get_loc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOneByCluesFound(int $clues_found) Return the first ChildGameRecord filtered by the clues_found column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOneByRevealTime(int $reveal_time) Return the first ChildGameRecord filtered by the reveal_time column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOneByRank(int $rank) Return the first ChildGameRecord filtered by the rank column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildGameRecord requireOneByQuestion(int $question) Return the first ChildGameRecord filtered by the question column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildGameRecord[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildGameRecord objects based on current ModelCriteria
 * @method     ChildGameRecord[]|ObjectCollection findByTeamID(int $team_id) Return ChildGameRecord objects filtered by the team_id column
 * @method     ChildGameRecord[]|ObjectCollection findByTimeFirstGetLoc(int $time_first_get_loc) Return ChildGameRecord objects filtered by the time_first_get_loc column
 * @method     ChildGameRecord[]|ObjectCollection findByCluesFound(int $clues_found) Return ChildGameRecord objects filtered by the clues_found column
 * @method     ChildGameRecord[]|ObjectCollection findByRevealTime(int $reveal_time) Return ChildGameRecord objects filtered by the reveal_time column
 * @method     ChildGameRecord[]|ObjectCollection findByRank(int $rank) Return ChildGameRecord objects filtered by the rank column
 * @method     ChildGameRecord[]|ObjectCollection findByQuestion(int $question) Return ChildGameRecord objects filtered by the question column
 * @method     ChildGameRecord[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class GameRecordQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Nutty\Models\Base\GameRecordQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'nutty', $modelName = '\\Nutty\\Models\\GameRecord', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildGameRecordQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildGameRecordQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildGameRecordQuery) {
            return $criteria;
        }
        $query = new ChildGameRecordQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildGameRecord|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(GameRecordTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = GameRecordTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildGameRecord A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT team_id, time_first_get_loc, clues_found, reveal_time, rank, question FROM nt_game_record WHERE team_id = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildGameRecord $obj */
            $obj = new ChildGameRecord();
            $obj->hydrate($row);
            GameRecordTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildGameRecord|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the team_id column
     *
     * Example usage:
     * <code>
     * $query->filterByTeamID(1234); // WHERE team_id = 1234
     * $query->filterByTeamID(array(12, 34)); // WHERE team_id IN (12, 34)
     * $query->filterByTeamID(array('min' => 12)); // WHERE team_id > 12
     * </code>
     *
     * @see       filterByTeam()
     *
     * @param     mixed $teamID The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByTeamID($teamID = null, $comparison = null)
    {
        if (is_array($teamID)) {
            $useMinMax = false;
            if (isset($teamID['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $teamID['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($teamID['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $teamID['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $teamID, $comparison);
    }

    /**
     * Filter the query on the time_first_get_loc column
     *
     * Example usage:
     * <code>
     * $query->filterByTimeFirstGetLoc(1234); // WHERE time_first_get_loc = 1234
     * $query->filterByTimeFirstGetLoc(array(12, 34)); // WHERE time_first_get_loc IN (12, 34)
     * $query->filterByTimeFirstGetLoc(array('min' => 12)); // WHERE time_first_get_loc > 12
     * </code>
     *
     * @param     mixed $timeFirstGetLoc The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByTimeFirstGetLoc($timeFirstGetLoc = null, $comparison = null)
    {
        if (is_array($timeFirstGetLoc)) {
            $useMinMax = false;
            if (isset($timeFirstGetLoc['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_TIME_FIRST_GET_LOC, $timeFirstGetLoc['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($timeFirstGetLoc['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_TIME_FIRST_GET_LOC, $timeFirstGetLoc['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_TIME_FIRST_GET_LOC, $timeFirstGetLoc, $comparison);
    }

    /**
     * Filter the query on the clues_found column
     *
     * Example usage:
     * <code>
     * $query->filterByCluesFound(1234); // WHERE clues_found = 1234
     * $query->filterByCluesFound(array(12, 34)); // WHERE clues_found IN (12, 34)
     * $query->filterByCluesFound(array('min' => 12)); // WHERE clues_found > 12
     * </code>
     *
     * @param     mixed $cluesFound The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByCluesFound($cluesFound = null, $comparison = null)
    {
        if (is_array($cluesFound)) {
            $useMinMax = false;
            if (isset($cluesFound['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_CLUES_FOUND, $cluesFound['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($cluesFound['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_CLUES_FOUND, $cluesFound['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_CLUES_FOUND, $cluesFound, $comparison);
    }

    /**
     * Filter the query on the reveal_time column
     *
     * Example usage:
     * <code>
     * $query->filterByRevealTime(1234); // WHERE reveal_time = 1234
     * $query->filterByRevealTime(array(12, 34)); // WHERE reveal_time IN (12, 34)
     * $query->filterByRevealTime(array('min' => 12)); // WHERE reveal_time > 12
     * </code>
     *
     * @param     mixed $revealTime The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByRevealTime($revealTime = null, $comparison = null)
    {
        if (is_array($revealTime)) {
            $useMinMax = false;
            if (isset($revealTime['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_REVEAL_TIME, $revealTime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($revealTime['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_REVEAL_TIME, $revealTime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_REVEAL_TIME, $revealTime, $comparison);
    }

    /**
     * Filter the query on the rank column
     *
     * Example usage:
     * <code>
     * $query->filterByRank(1234); // WHERE rank = 1234
     * $query->filterByRank(array(12, 34)); // WHERE rank IN (12, 34)
     * $query->filterByRank(array('min' => 12)); // WHERE rank > 12
     * </code>
     *
     * @param     mixed $rank The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByRank($rank = null, $comparison = null)
    {
        if (is_array($rank)) {
            $useMinMax = false;
            if (isset($rank['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_RANK, $rank['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($rank['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_RANK, $rank['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_RANK, $rank, $comparison);
    }

    /**
     * Filter the query on the question column
     *
     * Example usage:
     * <code>
     * $query->filterByQuestion(1234); // WHERE question = 1234
     * $query->filterByQuestion(array(12, 34)); // WHERE question IN (12, 34)
     * $query->filterByQuestion(array('min' => 12)); // WHERE question > 12
     * </code>
     *
     * @param     mixed $question The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByQuestion($question = null, $comparison = null)
    {
        if (is_array($question)) {
            $useMinMax = false;
            if (isset($question['min'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_QUESTION, $question['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($question['max'])) {
                $this->addUsingAlias(GameRecordTableMap::COL_QUESTION, $question['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(GameRecordTableMap::COL_QUESTION, $question, $comparison);
    }

    /**
     * Filter the query by a related \Nutty\Models\Team object
     *
     * @param \Nutty\Models\Team|ObjectCollection $team The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildGameRecordQuery The current query, for fluid interface
     */
    public function filterByTeam($team, $comparison = null)
    {
        if ($team instanceof \Nutty\Models\Team) {
            return $this
                ->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $team->getTeamID(), $comparison);
        } elseif ($team instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $team->toKeyValue('PrimaryKey', 'TeamID'), $comparison);
        } else {
            throw new PropelException('filterByTeam() only accepts arguments of type \Nutty\Models\Team or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Team relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function joinTeam($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Team');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Team');
        }

        return $this;
    }

    /**
     * Use the Team relation Team object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Nutty\Models\TeamQuery A secondary query class using the current class as primary query
     */
    public function useTeamQuery($relationAlias = null, $joinType = 'Criteria::INNER_JOIN')
    {
        return $this
            ->joinTeam($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Team', '\Nutty\Models\TeamQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildGameRecord $gameRecord Object to remove from the list of results
     *
     * @return $this|ChildGameRecordQuery The current query, for fluid interface
     */
    public function prune($gameRecord = null)
    {
        if ($gameRecord) {
            $this->addUsingAlias(GameRecordTableMap::COL_TEAM_ID, $gameRecord->getTeamID(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the nt_game_record table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GameRecordTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            GameRecordTableMap::clearInstancePool();
            GameRecordTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(GameRecordTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(GameRecordTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            GameRecordTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            GameRecordTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // GameRecordQuery
