<!DOCTYPE html>
<html class="no-js" lang="en" dir="ltr">
<head>

    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nutty - Login</title>
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/foundation.css">
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/app.css">
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/main.css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:700|Open+Sans" rel="stylesheet">
    <link rel="shortcut icon" href="<?=ntGetRootDir()?>/assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?=ntGetRootDir()?>/assets/img/favicon.ico" type="image/x-icon">
    <style>
        img {
            float: right;
            width: 17%;
            height: auto;
            padding-left: 0.4rem;
        }
        .callout.alert{
            margin-bottom: 1em;
        }
        .callout.primary {
            margin-top: 1em;
        }
        .slight-offset {
            position: relative;
            top: 3rem;
            top: 18vh;
        }
    </style>

</head>

<body>
<div class="background-fly" id="bg-one"></div>
<div class="background-fly" id="bg-two"></div>
<div class="column row row-small slight-offset">
    <div class="column row gradient">
        <h2 style="color:#FFF">User Portal</h2>
    </div>
    <div class="column row main-content" style="padding:2rem;">
        <form data-abide method="post"  novalidate>
            <div
                    data-abide-error
                    class="alert callout"
                    <?=isset($err) ? '' : 'style="display: none;"'?>
            >
                <img src="<?=ntGetRootDir()?>/assets/img/hazel-logo.png" alt="Nutty Logo">
                <p>
                    Oops! Something wasn't quite right there! <?=isset($err) ? $err : ''?>
                </p>
            </div>
            <label>
                E-mail Address
                <input
                        type="email"
                        name="email"
                        required
                        aria-describedby="eid"
                        pattern="email"
                        value="<?=isset($email) ? $email : ''?>"
                >
                <span class="form-error" id="eid">Please enter a valid E-mail Address.</span>
            </label>
            <label>
                Password
                <input type="password" name="password" minlength="8" maxlength="16" required aria-describedby="pid">
                <span class="form-error" id="pid">Invalid Password.</span>
            </label>
            <fieldset>
                <p>Our website uses <span data-tooltip aria-haspopup="true" class="has-tip" data-disable-hover="false" tabindex="1" title="We use cookies to remember things about you.">cookies</span> to function. You can find out more about cookies and our policy by clicking here.</p>
                <input id="ucookies" type="checkbox" required aria-describedby="uch"><label for="ucookies">I accept cookies</label>
                <span class="form-error" id="uch">You must accept cookies to proceed.</span>
            </fieldset>
            <button class="button" type="submit" value="Submit" style="width:100%;">Login</button>
        </form>
    </div>
</div><!-- End row -->


<script src="<?=ntGetRootDir()?>/assets/js/vendor/jquery.js"></script>
<script src="<?=ntGetRootDir()?>/assets/js/vendor/what-input.js"></script>
<script src="<?=ntGetRootDir()?>/assets/js/vendor/foundation.js"></script>
<script src="<?=ntGetRootDir()?>/assets/js/app.js"></script>
<script type="text/javascript">
    alert('Dear the marker:\nWe forgot to provide username & password for testing in the final submission. This dialog is not a part of the final product. \nUsername: nutty@ncl.ac.uk\nPassword: HazelLovesNut');
</script>
</body>
</html>