<?php $this->layout('Layouts/MainLayout', ['title' => 'Home']) ?>


<div class="column row main-content">
    <div class="column row main-content" id="jumbo-img">
        <iframe width="100%" height="500em" src="https://www.youtube.com/embed/BOoZow-onSg?ecver=1" frameborder="0" allowfullscreen style="margin=0"></iframe>
    </div>

    <div id="intro">
        <h1>Let's Get Cracking!</h1>
        <ul>
            <li><strong>Explore</strong> and discover what’s in and around your campus!</li>
            <li><strong>Solve</strong> clues along the way to find your next location!</li>
            <li><strong>Compete</strong> head-to-head with your friends for the best score, keeping track through our live scoreboard!</li>
        </ul>
    </div>
    <hr>
    <div class="row">
        <div class="large-4 columns text-center">
            <img src="<?=ntGetRootDir()?>/assets/img/box.png" alt="Treasure Box" onmouseover="this.src='assets/img/box_1.png'" onmouseout="this.src='assets/img/box.png'" class="responsive">
        </div>
        <div class="large-8 columns">
            <h2>What is Nutty?</h2>
            <p>Newcastle University Treasure Trail Year1 or Nutty, is the new and innovative way to explore. A concise and user-friendly treasure hunt app that reduces the resources needed to run large-scale treasure hunts. Nutty reduces paper waste and keeps the number of humans to organise the hunt to a minimum. Nutty is a great way to teach team working skills and show off your environment.</p>
        </div>
    </div>
    <div class="row" data-equalizer>
        <div class="large-4 large-push-8 columns text-center" data-equalizer-watch>
            <img src="<?=ntGetRootDir()?>/assets/img/hazel.png" alt="Hazel the Squirrel" class="responsive">
        </div>
        <div class="large-8 large-pull-4 columns" data-equalizer-watch>
            <h2>Meet Hazel</h2>
            <p>Hazel the squirrel, the mascot for Nutty, will help guide you through the app by providing clues and hints along the trail as well as a friendly face to increase user connectivity. Hazel ties in with the name of the app and she represents the key characteristics to successfully complete a treasure hunt.</p>
        </div>
    </div>
    <div class="row" data-equalizer>
        <div class="large-4 columns text-center" data-equalizer-watch>
            <img src="<?=ntGetRootDir()?>/assets/img/phones.png" alt="Screenshots of the Application" class="responsive">
        </div>
        <div class="large-8 columns" data-equalizer-watch>
            <h2>How the app works</h2>
            <p>Activate a hunt by entering the password you have been given by your hunt leader. Solve each clue to find your next location. Scan the QR code you find to complete the clue. The next clue will be given to you only once you have solved the previous one. If you have not found the QR code within a certain amount of time from the clue, we will give you an extra hint. You will receive a location radius to show you the area the QR code is on the map to narrow down your search. The time it takes you to scan the QR code from when you first receive the clue to that location will be recorded. The faster your time, the higher your score! A live scoreboard will be available on the app throughout your hunt so that you can compare your times and compete with the other teams. At the end of the hunt when all the clues have been completed, you will be entered into a bonus quiz to test your knowledge of the campus. The more correct answers you give, the more points you will receive. The team with the highest overall score wins!</p>
        </div>
    </div>
    <div class="row column"><h5>You’d have to be <strong>NUTS</strong> not to enjoy our app!</h5></div>
    <hr>
    <div class="row" style="text-align:center;">
        <div class="large-4 medium-6 small-12 columns fade">
            <img src="<?=ntGetRootDir()?>/assets/img/clue%201.png" alt="Screenshot of the app's interface showing a clue" class="rounded">
            <h3>Step One</h3>
            <p><strong>Get thinking!</strong> Once the hunt has started, Hazel will provide you with a clue. Solve the clue to find the location of the QR code. Once found, scan the code and receive your next clue.</p>
        </div>
        <div class="large-4 medium-6 small-12 columns fade">
            <img src="<?=ntGetRootDir()?>/assets/img/leaderboard.png" alt="Screenshot of the app's leaderboard interface" class="rounded">
            <h3>Step Two</h3>
            <p><strong>Be the fastest!</strong> Don’t forget your times are being recorded and scored so the faster you complete your clues, the higher you will score.</p>
        </div>
        <div class="large-4 medium-12 columns fade">
            <img src="<?=ntGetRootDir()?>/assets/img/quiz%20right.png" alt="Screenshot showing the quiz interface" class="rounded">
            <h3>Step Three</h3>
            <p><strong>Quiz Time!</strong> Answer as many questions correctly as you can to earn more points. You'll then get given your final score!</p>
        </div>
    </div>
    <hr>
    <div class="row">
        <div class="medium-4 columns hide-for-small-only">
            <img src="<?=ntGetRootDir()?>/assets/img/hazel.png" alt="Hazel the Squirrel" class="hazel">
        </div>
        <div class="medium-8 small-12 columns text-center">
            <div class="bubble-arrow hide-for-small-only"></div>
            <div class="bubble">
                <h4>Get Nutty now!</h4>
                <p>Download it from Google Play or download one of our user manuals!</p>
                <a href="<?=ntGetRootDir()?>/appmanual" class="button" style="width:10rem;">App Manual</a>
                <a href="<?=ntGetRootDir()?>/sitemanual" class="button" style="width:10rem;">Website Manual</a>
                <a
                        href="<?=ntGetRootDir()?>/download"
                        target="_blank"
                >
                    <img src="<?=ntGetRootDir()?>/assets/img/google-play-badge.png"
                         alt="Download on Google playstore"
                         style="width: 10rem;"
                    >
                </a>
            </div>
        </div>
    </div>
</div>