<!DOCTYPE html>
<html class="no-js" lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nutty - <?=$this->e($title)?></title>
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/foundation.css">
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/app.css">
    <link rel="stylesheet" href="<?=ntGetRootDir()?>/assets/css/main.css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:700|Open+Sans" rel="stylesheet">
    <?php if ($this->section('extraCSS')): ?>
        <?=$this->section('extraCSS')?>
    <?php endif ?>
    <link rel="shortcut icon" href="<?=ntGetRootDir()?>/assets/img/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?=ntGetRootDir()?>/assets/img/favicon.ico" type="image/x-icon">

    <?php if ($this->section('extraStyle')): ?>
        <?=$this->section('extraStyle')?>
    <?php endif ?>
</head>

<body>
<div class="background-fly" id="bg-one"></div>
<div class="background-fly" id="bg-two"></div>
<div class="row">
    <div data-sticky-container id="sticky-navrow">
        <div class="row gradient" data-sticky data-options="marginTop:0;" style="width:100%">
            <div class="medium-5 columns logo-container">
                <div id="logo-banner">
                    <a href="<?=ntGetRootDir()?>/">
                    <img src="<?=ntGetRootDir()?>/assets/img/logo.png" alt="Nutty logo" />
                    </a>
                </div>
            </div>
            <div class="medium-7 columns nav-center">
                <ul class="menu">
                    <?php if (Auth::isAuthenticated()): ?>
                        <li><a href="<?=ntGetRootDir()?>/">Home</a></li>
                        <li><a href="<?=ntGetRootDir()?>/staff/portal">Portal</a></li>
                        <li><a href="<?=ntGetRootDir()?>/auth/logout">Log out</a></li>
                    <?php else: ?>
                        <li><a href="<?=ntGetRootDir()?>/">Home</a></li>
                        <li><a href="<?=ntGetRootDir()?>/getnutty">Get Nutty</a></li>
                        <li><a href="<?=ntGetRootDir()?>/auth/login">Log in</a></li>
                    <?php endif ?>
                </ul>
            </div>
        </div>
    </div>
    <?=$this->section('content')?>
</div><!-- End row -->

<footer>
    <div class="row column gradient clearfix" data-equalizer>
        <div class="float-left" data-equalizer-watch>
            <a href="<?=ntGetRootDir()?>/team#contactUs" target="_self"><h5>Get in touch</h5></a>
            <a href="<?=ntGetRootDir()?>/team" target="_self"><h5>Meet the team</h5></a>
            <a href="http://www.facebook.com/NuttyandHazel/" target="_blank"><h5>Like us on Facebook</h5></a>
            <p>&copy; Nutty 2016-2017. Google Play and the Google Play logo are trademarks of Google Inc.</p>
        </div>
        <div class="float-right" data-equalizer-watch>
            <img src="<?=ntGetRootDir()?>/assets/img/hazel-logo.png" alt="Hazel the Squirrel wearing a t-shirt with the Nutty Logo on" class="responsive">
        </div>
    </div>
</footer>

<script src="<?=ntGetRootDir()?>/assets/js/vendor/jquery.js"></script>
<script src="<?=ntGetRootDir()?>/assets/js/vendor/what-input.js"></script>
<script src="<?=ntGetRootDir()?>/assets/js/vendor/foundation.js"></script>
<?php if ($this->section('extraJS')): ?>
    <?=$this->section('extraJS')?>
<?php endif ?>
<script src="<?=ntGetRootDir()?>/assets/js/app.js"></script>
</body>
</html>