<?php

/**
 * Service Provider for wrapper classes for team apis.
 *
 * @author Congyu Fan
 */

namespace App\Providers;

use App\Models\TeamDefaults\TeamHuntWrapper;
use App\Models\TeamDefaults\TeamTeamWrapper;
use Azi\Input;
use Nutty\Core\IoC\AbstractServiceProvider;
use Nutty\Models\TeamQuery;
use Propel\Runtime\ActiveQuery\Criteria;


/**
 * Class ModelsProvider
 * @package App\Providers
 */
class TeamModelsProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register()
    {
        //For TeamTeamWrapper
        $this->container->bindSingleton(
            TeamTeamWrapper::class,
            function() {
                $pwd = ntGetRequestInput('team_pwd');

                // If password not submitted
                if (!$pwd) {
                    return null;
                }

                //Try to find the team
                $team = TeamQuery::create()
                    ->filterByTeamPWD($pwd)
                    ->findOne();

                if (!$team) {
                    return null;
                }

                // Case Sensitive
                if ($team->getTeamPWD() !== $pwd) {
                    return null;
                }

                return $team ? (new TeamTeamWrapper($team)) : null;
            }
        );

        // for TeamHuntWrapper
        $this->container->bindSingleton(
            TeamHuntWrapper::class,
            function (TeamTeamWrapper $teamWrapper = null) {
                return $teamWrapper? new TeamHuntWrapper($teamWrapper->getWrapped()->getHunt()) : null;
            }
        );

    }
}