<?php
/**
 * Service provider for Distance calculating.
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */

namespace App\Providers;

use LucDeBrouwer\Distance\Distance;
use Nutty\Core\IoC\AbstractServiceProvider;

/**
 * Class DistanceProvider
 * @package App\Providers
 */
class DistanceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register()
    {
        $this->container->bindSingleton(
            Distance::class,
            function() {
                $distance = new Distance();
                //Set the unit.
                $distance->setUnit('m');
                return $distance;
            }
        );
    }
}