<?php
/**
 * Service provider for bad word filter.
 *
 * @author Congyu Fan
 * @since Apr 25, 2017
 */

namespace App\Providers;


use Expalmer\PhpBadWords\PhpBadWords;
use Nutty\Core\IoC\AbstractServiceProvider;

/**
 * Class BadWordProvider
 * @package App\Providers
 */
class BadWordProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function register() {
        $this->container->bindSingleton(
            'badWord',
            function () {
                $filter = new PhpBadWords();

                //Load dictionary from file.
                $filter->setDictionaryFromArray(ntGetConfigFile(NUTTY_CONFIG_DIR.'/swear_words.php'));
                return $filter;
            }
        );
    }
}