<?php
/**
 * Wrapper class for Team model for staff APIs
 *
 * @author Congyu Fan
 */

namespace App\Models\StaffDefaults;


use App\Misc\Exception\RequestErrorException;
use App\Misc\MessagePush\Email;
use App\Models\TeamWrapper;
use Kayex\HttpCodes;
use Nutty\Models\Base\Team;
use Propel\Runtime\Connection\ConnectionInterface;


/**
 * Class StaffTeamWrapper
 * @package App\Models\StaffDefaults
 */
class StaffTeamWrapper extends TeamWrapper
{
    /**
     * StaffTeamWrapper constructor.
     * @param Team $team
     */
    public function __construct(Team $team)
    {
        parent::__construct($team);
    }

    /**
     * Reset the game record of the wrapped team.
     *
     * @param ConnectionInterface|null $con
     */
    public function resetGameRecord(ConnectionInterface $con = null)
    {
        //$this->getWrapped()->setTotalDist(0);
        $gameRecord = $this->getGameRecord();
        $gameRecord->setCluesFound(0);
        $gameRecord->setTimeFirstGetLoc(0);
        $gameRecord->setRevealTime(0);
        $gameRecord->setRank(0);
        $gameRecord->setQuestion(0);
        $gameRecord->save($con);
    }

    /**
     * Reset the data of the wrapped team.
     *
     * @param string $newPwd A new password
     * @param ConnectionInterface|null $con
     */
    public function resetTeam($newPwd, ConnectionInterface $con = null)
    {
        //Reset the game record first
        $this->resetGameRecord($con);
        $team = $this->getWrapped();
        $team->setTeamName(null);
        $team->setEmail(null);
        $team->setTeamPWD($newPwd);
        $team->save($con);
    }


    /**
     * Send the password of the current team to an email address.
     *
     * @param ConnectionInterface|null $con
     * @throws RequestErrorException
     */
    public function distPwdByEmail(ConnectionInterface $con = null)
    {
        $team = $this->getWrapped();
        $hunt = $team->getHunt($con);

        //Get the timestamp of the last time the password of this team was distribute via email.
        $lastEmail = $team->getLastEmail();

        // If less than minimum interval.
        if (time() - $lastEmail <= ntLoadGlobalConfig('min_team_email_interval')) {
            throw new RequestErrorException(HttpCodes::HTTP_SERVICE_UNAVAILABLE, 'You can not send email for this team in 1 min');
        }

        // If the hunt is end.
        if ((new StaffHuntWrapper($hunt))->getTimeLeft() == 0) {
            throw new RequestErrorException(HttpCodes::HTTP_CONFLICT, ntGetStringLiteral('HUNT_IS_END'));
        }

        $email = ntGetRequestInput('email_addr');

        //If the email is not given
        if (!$email) {
            //Get the email stored in the database.
            $email = $team->getEmail();
            if (!$email) {
                throw new RequestErrorException(HttpCodes::HTTP_CONFLICT, ntGetStringLiteral('INVALID_EMAIL'));
            }
        }

        //Send the email
        $ret = Email::push(
            Auth::getName(),
            $email,
            'Newcastle University Treasure Hunt Password',
            'Your password is '.$team->getTeamPWD()
            );

        if ($ret !== true) {
            throw new RequestErrorException(HttpCodes::HTTP_SERVICE_UNAVAILABLE, 'Failed to push email');
        }

        //Save the email address
        $team->setEmail($email) ->setLastEmail(time())->save($con);
    }
}