<?php
/**
 * Wrapper class for Location model for staff APIs
 *
 * @author Congyu Fan
 */

namespace App\Models\StaffDefaults;


use App\Models\LocationWrapper;
use Nutty\Models\Base\Location;
use Propel\Runtime\Connection\ConnectionInterface;

/**
 * Class StaffLocationWrapper
 * @package App\Models\StaffDefaults
 */
class StaffLocationWrapper extends LocationWrapper
{
    public function __construct(Location $location)
    {
        parent::__construct($location);
    }

    /**
     * Update a location
     * @param ConnectionInterface|null $con
     */

    public function updateLoc(ConnectionInterface $con = null)
    {
        $name = ntGetRequestInput('name');
        $clue = ntGetRequestInput('clue');
        $latitude = ntGetRequestInput('latitude');
        $longitude = ntGetRequestInput('longitude');

        $location = $this->getWrapped();

        if ($name) {
            $location->setName($name);
        }

        if ($clue) {
            $location->setClue($clue);
        }

        if ($latitude && $longitude) {
            $location->setLatitude($latitude);
            $location->setLongitude($longitude);
        }

        $location->save($con);
    }
}