<?php
/**
 * Wrapper class for LocationTemplate model for staff APIs
 */

namespace App\Models\StaffDefaults;


use App\Misc\Exception\RequestErrorException;
use App\Models\LocTemplateWrapper;
use Kayex\HttpCodes;
use Nutty\Models\LocationTemplate;
use Nutty\Models\LocationTemplateQuery;
use Propel\Runtime\Connection\ConnectionInterface;


/**
 * Class StaffLocTemplateWrapper
 * @package App\Models\StaffDefaults
 */
class StaffLocTemplateWrapper extends LocTemplateWrapper
{
    /**
     * StaffLocTemplateWrapper constructor.
     * @param LocationTemplate $locationTemplate
     */
    public function __construct(LocationTemplate $locationTemplate)
    {
        parent::__construct($locationTemplate);
    }

    /**
     * Update a template
     *
     * @param ConnectionInterface|null $con
     */
    public function updateTemplate(ConnectionInterface $con = null)
    {
        $name = ntGetRequestInput('name');
        $clue = ntGetRequestInput('clue');
        $latitude = ntGetRequestInput('latitude');
        $longitude = ntGetRequestInput('longitude');

        $template = $this->getWrapped();

        if ($name) {
            $template->setName($name);
        }

        if ($clue) {
            $template->setClue($clue);
        }

        if ($latitude && $longitude) {
            $template->setLatitude($latitude);
            $template->setLongitude($longitude);
        }

        $template->save($con);
    }

    /**
     * Create a template
     *
     * @param ConnectionInterface|null $con
     * @return int
     * @throws RequestErrorException
     */
    public static function createTemplate(ConnectionInterface $con = null)
    {
        $templateNum = LocationTemplateQuery::create()
            ->filterByCreatorID(Auth::getIdentification())
            ->count();

        //If too many templates have been created.
        if ($templateNum >= ntLoadGlobalConfig('max_template_num')) {
            throw new RequestErrorException(HttpCodes::HTTP_BAD_REQUEST, ntGetStringLiteral('TEMP_TOO_MANY'));
        }

        $name = ntGetRequestInput('name');
        $clue = ntGetRequestInput('clue');
        $latitude = ntGetRequestInput('latitude');
        $longitude = ntGetRequestInput('longitude');

        //Create a new template.
        $template = new LocationTemplate();
        $template->setCreatorID(Auth::getIdentification());
        $template->setName($name);
        $template->setClue($clue);
        $template->setLatitude($latitude);
        $template->setLongitude($longitude);
        $template->save($con);

        // Return the id of the newly created template.
        return $template->getLocationID();
    }

    /**
     * Get template list.
     *
     * @param ConnectionInterface|null $con
     * @return array
     */
    public static function getTemplates(ConnectionInterface $con = null) {
        $locations = LocationTemplateQuery::create()
            ->filterByCreatorID(Auth::getIdentification())
            ->find($con);

        $ret = [];

        foreach ($locations as $location) {
            array_push(
                $ret,
                [
                    'id' => $location->getLocationID(),
                    'name' => $location->getName(),
                    'clue' => $location->getClue(),
                    'latitude' => $location->getLatitude(),
                    'longitude' => $location->getLongitude()
                ]
            );
        }

        return $ret;
    }
}