<?php
/**
 * Validate staff quiz question APIs
 *
 * @author Congyu Fan
 */

namespace App\Misc\Validation;


use Respect\Validation\Validator as V;

class StaffQuizQuestionValidate implements InputValidateInterface
{
    /**
     * Validate quiz question
     *
     * @param $errMsg
     * @return bool
     */
    private function validateQuestion(&$errMsg)
    {
        $question = ntGetRequestInput('quiz_question');

        if (!Validation::quizQuestion($question)) {
            $errMsg = 'Invalid question';
            return false;
        }

        if (Validation::badWords($question)) {
            $errMsg = 'Question'.ntGetStringLiteral('CONTAIN_BAD_WORD');
            return false;
        }

        return true;
    }

    /**
     * Validate question id
     *
     * @param $errMsg
     * @return bool
     */
    private function validateQuestionId(&$errMsg)
    {
        if (!V::intVal()->Min(0)->validate(ntGetRequestInput('question_id'))) {
            $errMsg = 'Invalid question id';
            return false;
        }
        return true;
    }

    /**
     * Validate hunt id.
     *
     * @param $errMsg
     * @return bool
     */
    private function validateHuntId(&$errMsg)
    {
        if (!V::intVal()->Min(0)->validate(ntGetRequestInput('hunt_id'))) {
            $errMsg = 'Invalid hunt id';
            return false;
        }
        return true;
    }

    /**
     * For question creating
     *
     * @param $errMsg
     * @return bool
     */
    private function validateCreate(&$errMsg)
    {
        if (!$this->validateQuestion($errMsg)) {
            return false;
        }

        if (!$this->validateHuntId($errMsg)) {
            return false;
        }

        return true;
    }

    /**
     * For question updating
     *
     * @param $errMsg
     * @return bool
     */
    private function validateUpdate(&$errMsg)
    {
        if (!$this->validateQuestion($errMsg)) {
            return false;
        }

        if (!$this->validateQuestionId($errMsg)) {
            return false;
        }

        return true;
    }

    public function validate($action, &$errMsg)
    {
        switch ($action) {
            case 'create':  //Creating a question
                return $this->validateCreate($errMsg);
            case 'update':  //Updating a question
                return $this->validateUpdate($errMsg);
            case 'retrieve':    //Retrieving question list
                return $this->validateHuntId($errMsg);
            case 'delete':  //deleting a question
                return $this->validateQuestionId($errMsg);
            default:
                $errMsg = ntGetStringLiteral('INVALID_ACTION');
                return false;
        }
    }
}