<?php
/**
 * Staff authentication APIs validation
 *
 * @author Congyu Fan
 * @since
 */

namespace App\Misc\Validation;


/**
 * Class StaffAuthValidation
 * @package App\Misc\Validation
 */
class StaffAuthValidation implements InputValidateInterface
{
    /**
     * @inheritDoc
     */
    public function validate($action, &$errMsg)
    {
        switch ($action) {
            case 'login': {     // For login
                $email = ntGetRequestInput('email');
                $password = ntGetRequestInput('password');

                //Email and password must exist
                if (!($email && $password)) {
                    $errMsg = ntGetStringLiteral('INVALID_LOGIN_INFORMATION');
                    return false;
                }

                if (!(Validation::email($email) && Validation::staffPassword($password))) {
                    $errMsg = ntGetStringLiteral('INVALID_LOGIN_INFORMATION');
                    return false;
                }

                return true;
            }
            case 'logout': {    //For logout
                return true;
            }
            default: {
                $errMsg = ntGetStringLiteral('INVALID_ACTION');
                return false;
            }
        }
    }
}