<?php
/**
 * Email sending module.
 * Use SMTP.
 *
 * @author Congyu Fan
 * @since Apr 23, 2017
 */

namespace App\Misc\MessagePush;

use Tx\Mailer;

class Email
{
    /**
     * @param string $from
     * @param string $to
     * @param string $subject
     * @param string $text
     * @return bool
     */
    public static function push($from, $to, $subject, $text)
    {
        $ret = (new Mailer())
            ->setServer(
                ntLoadGlobalConfig('email_smtp_host'),
                ntLoadGlobalConfig('email_smtp_port'),
                ntLoadGlobalConfig('email_smtp_secure'))
            ->setAuth(
                ntLoadGlobalConfig('email_smtp_user'),
                ntLoadGlobalConfig('email_smtp_pass'))
            ->setFrom('Nutty', $from)
            ->addTo('', $to)
            ->setSubject($subject)
            ->setBody($text)
            ->send();

        return $ret;
    }
}