<?php
/**
 * User authentication for teams
 *
 * @author Congyu Fan
 * @since Mar 21, 2017
 */

namespace App\Misc\Auth;

use App\Models\TeamDefaults\TeamTeamWrapper;
use Nutty\Models\Team;

class TeamAuth implements AuthInterface
{
    /**@var Team $teamInfo The information of the current team*/
    private $teamInfo = null;

    /**
     * APIAuth constructor.
     * @param TeamTeamWrapper|null $teamWrapper The information of the current team
     */
    public function __construct(TeamTeamWrapper $teamWrapper = null)
    {
        if ($teamWrapper) {
            $this->teamInfo = $teamWrapper->getWrapped();
        }
    }

    /**
     * @inheritDoc
     */
    public function isAuthenticated()
    {
        //If the TeamModel obtained in the constructor is not null
        if (!$this->teamInfo) {
            return false;
        }

        return true;
    }

    /**
     * @inheritDoc
     */
    public function getName()
    {
        if (!isset($this->teamInfo)) {
            return null;
        }

        return $this->teamInfo->getTeamName();
    }

    /**
     * @inheritDoc
     */
    public function getIdentification()
    {
        if (!isset($this->teamInfo)) {
            return null;
        }

        return $this->teamInfo->getTeamID();
    }
}