<?php
/**
 * Interface for authentication classes
 *
 * @author Congyu Fan
 * @since Mar 17, 2017
 */

namespace App\Misc\Auth;

/**
 * Interface AuthInterface
 * @package App\Misc\Auth
 */
interface AuthInterface
{
    /**
     * Indicates whether the user is authenticated or not
     *
     * @return bool : true if authenticated, false if not.
     */
    public function isAuthenticated();

    /**
     * @return string|null Get the name/email of the user. If not provided, may return null.
     */
    public function getName();

    /**
     * @return mixed|null Get the identification of the user.
     */
    public function getIdentification();
}