<?php
/**
 * To generate keys.
 *
 * @author Congyu Fan & Li Chern
 * @since Apr 1, 2017
 */

namespace App\Misc\API;


use Nutty\Models\Base\Location;
use Nutty\Models\Base\Staff;

/**
 * Class LocationKey
 * @package App\Misc\API
 */
class KeyGenerator
{
    const REACH_LOC_CODE_LENGTH = 8;        //The length of the location key.

    private static function genRandomString($len = 8)
    {
        $alphabet = "abcdefghijklmnopqrstuwxyzABCDEFGHIJKLMNOPQRSTUWXYZ0123456789";
        //Creating the array which the password will be held in
        $finalPass = array();
        //Setting the length of the alphabet. There is a -1 to prevent running out of bounds
        $alphaLength = strlen($alphabet) - 1;

        //This will help create the password of length 8
        for ($i = 0; $i < $len; $i++) {
            $n = rand(0, $alphaLength);
            $finalPass[] = $alphabet[$n];
        }
        //Converts the array into a string
        return implode($finalPass);
    }

    /**
     * To generate a security key for a location.
     *
     * @param Location $location
     * @return string A security key.
     */
    public static function locationKey(Location $location)
    {
        $locationOrder = $location->getLocationOrder();
        $keyLen = ntLoadGlobalConfig('loc_key_len');

        return substr(md5("$locationOrder".$location->getHuntID()), -$keyLen, $keyLen);
    }

    /**
     * Generate a encrypted password by the cleartext password and the salt.
     *
     * @param string $pwd The cleartext password
     * @param string $salt
     *
     * @return null|string string if success. null if the given arguments are not strings.
     */
    public static function genPassword($pwd, $salt = '')
    {
        if (is_string($pwd) && is_string($salt)) {
            return md5(md5($pwd).$salt);
        }

        return null;
    }

    /**
     * To generate a team password
     * @return string
     */
    public static function genTeamPassword()
    {
        return self::genRandomString(ntLoadGlobalConfig('team_pwd_len'));
    }

    /**
     * To generate a login token for a staff.
     *
     * @return string
     */
    public static function genLoginToken() {
        return self::genRandomString(8);
    }

    /**
     * To generate a login ticket for a Staff object.
     *
     * @param Staff $staff
     * @return string
     */
    public static function genLoginTicket(Staff $staff) {
        $id = $staff->getEmail();
        $email = $staff->getEmail();
        $salt = $staff->getSalt();
        $token = $staff->getToken();
        $token = $token ? $token : ' ';

        $ticket = md5($email.$id.$salt);
        $ticket = md5($ticket.$token.$salt);

        return $ticket;
    }
}