<?php
/**
 * JSON object response generator for APIs.
 *
 * @author Congyu Fan
 * @since Apr 1, 2017
 */
namespace App\Misc\API;


use Kayex\HttpCodes;

class APIResponseGenerator
{
    /**
     * Generate a response with an error code and a error message.
     * The header will also be set.
     *
     * @param int $errCode : Error code. Indicates error status , 0 no error, 1 password invalid, 2 server error
     * @param string $errMsg : Descriptive text string
     *
     * @return string
     */
    public static function genJsonErrorMsg($errCode = HttpCodes::HTTP_INTERNAL_SERVER_ERROR, $errMsg = 'Unknown server error')
    {
        //Set http header.
        header('Content-type:application/json;charset=utf-8');
        header('Access-Control-Allow-Origin: *');

        $msg = ['error' => $errCode];
        $msg['message'] = $errMsg;

        return json_encode($msg, JSON_PRETTY_PRINT);
    }

    /**
     * The header will also be set.
     *
     * @param array $arr
     *
     * @return string
     */
    public static function genArrayJson(array $arr)
    {
        //Set http header.
        header('Content-type:application/json;charset=utf-8');
        header('Access-Control-Allow-Origin: *');

        return json_encode([/*'status' => HttpCodes::HTTP_OK, */'data' => $arr], JSON_PRETTY_PRINT);
    }
}