<?php
/**
 * Controller for staff authentication APIs
 *
 * @since Apr 24, 2017
 * @author Congyu Fan
 */

namespace App\Controllers\Site;

use App\Misc\Auth\StaffLogin;
use App\Misc\Exception\RequestErrorException;
use Bistro\Session\Session;
use Nutty\Controller\AbstractController;
use Nutty\Models\Map\StaffTableMap;
use OhHttp\Request;
use OhHttp\Response;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Propel;

/**
 * Class StaffAuthController
 * @package App\Controllers\Site
 */
class StaffAuthController  extends AbstractController
{
    public function login(Request $request)
    {
        StaffLogin::logout();
        $method = $request->getRequestMethod();
        if ($method === 'GET') {
            return ntRenderView('Pages/Login');
        } elseif ($method === 'POST') {
            $errMsg = null;
            if (!(new \App\Misc\Validation\StaffAuthValidation)
                ->validate('login', $errMsg)) {
                return ntRenderView('Pages/Login', ['err' => $errMsg]);
            }

            $con = Propel::getConnection(StaffTableMap::DATABASE_NAME);
            $con->beginTransaction();
            try {
                StaffLogin::login($con);
                $con->commit();
            } catch (PropelException $e) {
                return ntRenderView('Pages/Login', ['err' => ntGetStringLiteral('DATABASE_ERROR')]);
            } catch (RequestErrorException $e) {
                return ntRenderView('Pages/Login',
                    [
                        'err' => $e->getMessage(),
                        'email' => ntGetRequestInput('email'),
                    ]
                );
            }

            header('Location: '.ntGetRootDir().'/staff/portal');
            //$response->redirect('/public/index2.html', 301);
            return '';
        }
        return '';
    }

    public function logout(Response $response)
    {
        StaffLogin::logout();

        // $response->redirect(ntGetRootDir().'/');
        header('Location: '.ntGetRootDir().'/');
    }
}