<?php
/**
 * Controller for teams to update information.
 *
 *
 * @since Apr 12, 2017
 * Time: 11:11 AM
 */

namespace App\Controllers\API;


use App\Misc\API\APIResponseGenerator;
use App\Models\TeamDefaults\TeamTeamWrapper;
use Nutty\Controller\AbstractController;
use Propel\Runtime\Connection\ConnectionInterface;


/**
 * Class TeamAPITeamController
 * @package App\Controllers\API
 */
class TeamAPITeamController extends AbstractController
{
    /**
     * Update team name.
     *
     * @param ConnectionInterface $con
     * @param TeamTeamWrapper $teamWrapper
     * @return string
     */
    public function update(ConnectionInterface $con, TeamTeamWrapper $teamWrapper)
    {
        $teamWrapper->updateName($con);
        return APIResponseGenerator::genArrayJson([]);
    }
}