<?php
/**
 * Controller for scoreboard team APIs
 *
 * @author Congyu Fan
 * @since Apr 20, 2017
 */

namespace App\Controllers\API;


use Nutty\Controller\AbstractController;
use App\Models\TeamDefaults\TeamHuntWrapper;
use App\Misc\API\APIResponseGenerator;


class TeamAPIScoreboardController extends AbstractController
{
    /**
     * Retrieve dynamic scoreboard
     *
     * @param TeamHuntWrapper $huntWrapper CurrentHunt
     *
     * @return string
     */
    public function liveScore(TeamHuntWrapper $huntWrapper)
    {
        return APIResponseGenerator::genArrayJson($huntWrapper->getLiveScoreBoard());
    }

    /**
     * Retrieve final scoreboard
     *
     * @param TeamHuntWrapper $huntWrapper
     * @return string
     */
    public function finalScore(TeamHuntWrapper $huntWrapper) {
        return APIResponseGenerator::genArrayJson($huntWrapper->getFinalScore());
    }
}