<?php
/**
 * Controller for quiz related team APIs
 *
 * @author Congyu Fan
 * @since Apr 12, 2017
 */
namespace App\Controllers\API;


use App\Misc\API\APIResponseGenerator;
use App\Misc\Exception\RequestErrorException;
use App\Models\TeamDefaults\TeamHuntWrapper;
use App\Models\TeamDefaults\TeamTeamWrapper;
use Kayex\HttpCodes;
use Nutty\Controller\AbstractController;
use Nutty\Models\Map\GameRecordTableMap;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Propel;

class TeamAPIQuizController extends AbstractController
{
    /**
     * Retrieve the quiz list
     *
     * @param TeamHuntWrapper $hunt
     * @param TeamTeamWrapper $teamWrapper
     * @return string
     */
    public function retrieve(TeamHuntWrapper $hunt, TeamTeamWrapper $teamWrapper)
    {
        // If the hunt is inactive.
        if (!$hunt->isActive()) {
            return APIResponseGenerator::genJsonErrorMsg(HttpCodes::HTTP_NOT_FOUND, ntGetStringLiteral('HUNT_INACTIVE'));
        }

        return APIResponseGenerator::genArrayJson($teamWrapper->retrieveQuestion());
    }

    /**
     * Submit the answer
     *
     * @param TeamHuntWrapper $hunt
     * @param TeamTeamWrapper $teamWrapper
     * @return string
     */
    public function update(TeamHuntWrapper $hunt, TeamTeamWrapper $teamWrapper)
    {
        //If the hunt is inactive.
        if (!$hunt->isActive()) {
            return APIResponseGenerator::genJsonErrorMsg(HttpCodes::HTTP_NOT_FOUND, ntGetStringLiteral('HUNT_INACTIVE'));
        }


        $ret = $teamWrapper->updateQuestionCounter();

        return APIResponseGenerator::genArrayJson($ret);
    }
}