<?php
/**
 * Controller for team hunt APIs
 *
 * @author Congyu Fan
 * @since Mar 29, 2017
 */

namespace App\Controllers\API;


use App\Models\TeamDefaults\TeamTeamWrapper;
use Nutty\Controller\AbstractController;
use App\Models\TeamDefaults\TeamHuntWrapper;
use App\Misc\API\APIResponseGenerator;


class TeamAPIHuntController extends AbstractController
{
    /**
     * Handles the queries for the hunt information
     *
     * @param TeamHuntWrapper $huntWrapper The wrapper class which container the
     *                          information of the hunt which the current user is in.
     * @param TeamTeamWrapper $teamWrapper The wrapper class for the current Team model.
     *
     * @return string
     */
    public function retrieve(TeamHuntWrapper $huntWrapper, TeamTeamWrapper $teamWrapper)
    {
        //Of a particular hunt, the array returned will be of the hunt's difficulty and the hunt's remaining time.
        $ret = [
            'difficulty' => $huntWrapper->getWrapped()->getDifficulty(),
            'time_left' => $huntWrapper->getTimeLeft(),
            'team_name' => $teamWrapper->getWrapped()->getTeamName(),
        ];

        return APIResponseGenerator::genArrayJson($ret);
    }
}