<?php
/**
 * Controller for location template management APIs
 *
 * @author Congyu Fan
 * @since Apr 7, 2017
 */

namespace App\Controllers\API;


use App\Misc\API\APIResponseGenerator;
use App\Models\StaffDefaults\StaffLocTemplateWrapper;
use Kayex\HttpCodes;
use Nutty\Controller\AbstractController;
use Propel\Runtime\Connection\ConnectionInterface;

/**
 * Class StaffLocTemplateController
 * @package App\Controllers\API
 */
class StaffLocTemplateController extends AbstractController
{
    /**
     * Get templates created by the current staff.
     *
     * @param ConnectionInterface $con
     * @return string
     */
    public function getTemplates(ConnectionInterface $con)
    {
        $ret = StaffLocTemplateWrapper::getTemplates($con);
        return APIResponseGenerator::genArrayJson($ret);
    }

    /**
     * Update the information of a template
     * @param ConnectionInterface $con
     * @param StaffLocTemplateWrapper|null $templateWrapper
     * @return string
     */
    public function updateTemplate(ConnectionInterface $con, StaffLocTemplateWrapper $templateWrapper = null)
    {
        // If template not found
        if (!$templateWrapper) {
            return APIResponseGenerator::genJsonErrorMsg(HttpCodes::HTTP_NOT_FOUND, ntGetStringLiteral('TEMP_NOT_FOUND'));
        }

        // Update template.
        $templateWrapper->updateTemplate($con);
        return APIResponseGenerator::genArrayJson([]);
    }

    /**
     * Remove a created template.
     *
     * @param ConnectionInterface $con
     * @param StaffLocTemplateWrapper|null $templateWrapper
     * @return string
     */
    public function removeTemplate(ConnectionInterface $con, StaffLocTemplateWrapper $templateWrapper = null)
    {
        // If template not found.
        if (!$templateWrapper) {
            return APIResponseGenerator::genJsonErrorMsg(HttpCodes::HTTP_NOT_FOUND, ntGetStringLiteral('TEMP_NOT_FOUND'));
        }

        // Delete.
        $templateWrapper->getWrapped()->delete($con);
        return APIResponseGenerator::genArrayJson([]);
    }

    /**
     * Create a new template
     *
     * @param ConnectionInterface $con
     * @return string
     */
    public function createTemplate(ConnectionInterface $con)
    {
        // Create a new template
        $newId = StaffLocTemplateWrapper::createTemplate($con);
        return APIResponseGenerator::genArrayJson(['template_id' => $newId]);
    }
}